import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaLayerVersionConfig extends TerraformMetaArguments {
    readonly compatibleRuntimes?: string[];
    readonly description?: string;
    readonly filename?: string;
    readonly layerName: string;
    readonly licenseInfo?: string;
    readonly s3Bucket?: string;
    readonly s3Key?: string;
    readonly s3ObjectVersion?: string;
    readonly sourceCodeHash?: string;
}
export declare class LambdaLayerVersion extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaLayerVersionConfig);
    get arn(): string;
    private _compatibleRuntimes?;
    get compatibleRuntimes(): string[] | undefined;
    set compatibleRuntimes(value: string[] | undefined);
    get createdDate(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _filename?;
    get filename(): string | undefined;
    set filename(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get layerArn(): string;
    private _layerName;
    get layerName(): string;
    set layerName(value: string);
    private _licenseInfo?;
    get licenseInfo(): string | undefined;
    set licenseInfo(value: string | undefined);
    private _s3Bucket?;
    get s3Bucket(): string | undefined;
    set s3Bucket(value: string | undefined);
    private _s3Key?;
    get s3Key(): string | undefined;
    set s3Key(value: string | undefined);
    private _s3ObjectVersion?;
    get s3ObjectVersion(): string | undefined;
    set s3ObjectVersion(value: string | undefined);
    private _sourceCodeHash?;
    get sourceCodeHash(): string | undefined;
    set sourceCodeHash(value: string | undefined);
    get sourceCodeSize(): number;
    get version(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
