import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LambdaPermissionConfig extends TerraformMetaArguments {
    readonly action: string;
    readonly eventSourceToken?: string;
    readonly functionName: string;
    readonly principal: string;
    readonly qualifier?: string;
    readonly sourceAccount?: string;
    readonly sourceArn?: string;
    readonly statementId?: string;
    readonly statementIdPrefix?: string;
}
export declare class LambdaPermission extends TerraformResource {
    constructor(scope: Construct, id: string, config: LambdaPermissionConfig);
    private _action;
    get action(): string;
    set action(value: string);
    private _eventSourceToken?;
    get eventSourceToken(): string | undefined;
    set eventSourceToken(value: string | undefined);
    private _functionName;
    get functionName(): string;
    set functionName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _principal;
    get principal(): string;
    set principal(value: string);
    private _qualifier?;
    get qualifier(): string | undefined;
    set qualifier(value: string | undefined);
    private _sourceAccount?;
    get sourceAccount(): string | undefined;
    set sourceAccount(value: string | undefined);
    private _sourceArn?;
    get sourceArn(): string | undefined;
    set sourceArn(value: string | undefined);
    private _statementId?;
    get statementId(): string | undefined;
    set statementId(value: string | undefined);
    private _statementIdPrefix?;
    get statementIdPrefix(): string | undefined;
    set statementIdPrefix(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
