import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LaunchConfigurationConfig extends TerraformMetaArguments {
    readonly associatePublicIpAddress?: boolean;
    readonly ebsOptimized?: boolean;
    readonly enableMonitoring?: boolean;
    readonly iamInstanceProfile?: string;
    readonly imageId: string;
    readonly instanceType: string;
    readonly keyName?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly placementTenancy?: string;
    readonly securityGroups?: string[];
    readonly spotPrice?: string;
    readonly userData?: string;
    readonly userDataBase64?: string;
    readonly vpcClassicLinkId?: string;
    readonly vpcClassicLinkSecurityGroups?: string[];
    /** ebs_block_device block */
    readonly ebsBlockDevice?: LaunchConfigurationEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: LaunchConfigurationEphemeralBlockDevice[];
    /** root_block_device block */
    readonly rootBlockDevice?: LaunchConfigurationRootBlockDevice[];
}
export interface LaunchConfigurationEbsBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly deviceName: string;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly noDevice?: boolean;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface LaunchConfigurationEphemeralBlockDevice {
    readonly deviceName: string;
    readonly virtualName: string;
}
export interface LaunchConfigurationRootBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export declare class LaunchConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: LaunchConfigurationConfig);
    get arn(): string;
    private _associatePublicIpAddress?;
    get associatePublicIpAddress(): boolean | undefined;
    set associatePublicIpAddress(value: boolean | undefined);
    private _ebsOptimized?;
    get ebsOptimized(): boolean | undefined;
    set ebsOptimized(value: boolean | undefined);
    private _enableMonitoring?;
    get enableMonitoring(): boolean | undefined;
    set enableMonitoring(value: boolean | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): string | undefined;
    set iamInstanceProfile(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _imageId;
    get imageId(): string;
    set imageId(value: string);
    private _instanceType;
    get instanceType(): string;
    set instanceType(value: string);
    private _keyName?;
    get keyName(): string | undefined;
    set keyName(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _placementTenancy?;
    get placementTenancy(): string | undefined;
    set placementTenancy(value: string | undefined);
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _spotPrice?;
    get spotPrice(): string | undefined;
    set spotPrice(value: string | undefined);
    private _userData?;
    get userData(): string | undefined;
    set userData(value: string | undefined);
    private _userDataBase64?;
    get userDataBase64(): string | undefined;
    set userDataBase64(value: string | undefined);
    private _vpcClassicLinkId?;
    get vpcClassicLinkId(): string | undefined;
    set vpcClassicLinkId(value: string | undefined);
    private _vpcClassicLinkSecurityGroups?;
    get vpcClassicLinkSecurityGroups(): string[] | undefined;
    set vpcClassicLinkSecurityGroups(value: string[] | undefined);
    private _ebsBlockDevice?;
    get ebsBlockDevice(): LaunchConfigurationEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: LaunchConfigurationEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): LaunchConfigurationEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: LaunchConfigurationEphemeralBlockDevice[] | undefined);
    private _rootBlockDevice?;
    get rootBlockDevice(): LaunchConfigurationRootBlockDevice[] | undefined;
    set rootBlockDevice(value: LaunchConfigurationRootBlockDevice[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
