import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LaunchTemplateConfig extends TerraformMetaArguments {
    readonly defaultVersion?: number;
    readonly description?: string;
    readonly disableApiTermination?: boolean;
    readonly ebsOptimized?: string;
    readonly imageId?: string;
    readonly instanceInitiatedShutdownBehavior?: string;
    readonly instanceType?: string;
    readonly kernelId?: string;
    readonly keyName?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly ramDiskId?: string;
    readonly securityGroupNames?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly updateDefaultVersion?: boolean;
    readonly userData?: string;
    readonly vpcSecurityGroupIds?: string[];
    /** block_device_mappings block */
    readonly blockDeviceMappings?: LaunchTemplateBlockDeviceMappings[];
    /** capacity_reservation_specification block */
    readonly capacityReservationSpecification?: LaunchTemplateCapacityReservationSpecification[];
    /** cpu_options block */
    readonly cpuOptions?: LaunchTemplateCpuOptions[];
    /** credit_specification block */
    readonly creditSpecification?: LaunchTemplateCreditSpecification[];
    /** elastic_gpu_specifications block */
    readonly elasticGpuSpecifications?: LaunchTemplateElasticGpuSpecifications[];
    /** elastic_inference_accelerator block */
    readonly elasticInferenceAccelerator?: LaunchTemplateElasticInferenceAccelerator[];
    /** hibernation_options block */
    readonly hibernationOptions?: LaunchTemplateHibernationOptions[];
    /** iam_instance_profile block */
    readonly iamInstanceProfile?: LaunchTemplateIamInstanceProfile[];
    /** instance_market_options block */
    readonly instanceMarketOptions?: LaunchTemplateInstanceMarketOptions[];
    /** license_specification block */
    readonly licenseSpecification?: LaunchTemplateLicenseSpecification[];
    /** metadata_options block */
    readonly metadataOptions?: LaunchTemplateMetadataOptions[];
    /** monitoring block */
    readonly monitoring?: LaunchTemplateMonitoring[];
    /** network_interfaces block */
    readonly networkInterfaces?: LaunchTemplateNetworkInterfaces[];
    /** placement block */
    readonly placement?: LaunchTemplatePlacement[];
    /** tag_specifications block */
    readonly tagSpecifications?: LaunchTemplateTagSpecifications[];
}
export interface LaunchTemplateBlockDeviceMappingsEbs {
    readonly deleteOnTermination?: string;
    readonly encrypted?: string;
    readonly iops?: number;
    readonly kmsKeyId?: string;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface LaunchTemplateBlockDeviceMappings {
    readonly deviceName?: string;
    readonly noDevice?: string;
    readonly virtualName?: string;
    /** ebs block */
    readonly ebs?: LaunchTemplateBlockDeviceMappingsEbs[];
}
export interface LaunchTemplateCapacityReservationSpecificationCapacityReservationTarget {
    readonly capacityReservationId?: string;
}
export interface LaunchTemplateCapacityReservationSpecification {
    readonly capacityReservationPreference?: string;
    /** capacity_reservation_target block */
    readonly capacityReservationTarget?: LaunchTemplateCapacityReservationSpecificationCapacityReservationTarget[];
}
export interface LaunchTemplateCpuOptions {
    readonly coreCount?: number;
    readonly threadsPerCore?: number;
}
export interface LaunchTemplateCreditSpecification {
    readonly cpuCredits?: string;
}
export interface LaunchTemplateElasticGpuSpecifications {
    readonly type: string;
}
export interface LaunchTemplateElasticInferenceAccelerator {
    readonly type: string;
}
export interface LaunchTemplateHibernationOptions {
    readonly configured: boolean;
}
export interface LaunchTemplateIamInstanceProfile {
    readonly arn?: string;
    readonly name?: string;
}
export interface LaunchTemplateInstanceMarketOptionsSpotOptions {
    readonly blockDurationMinutes?: number;
    readonly instanceInterruptionBehavior?: string;
    readonly maxPrice?: string;
    readonly spotInstanceType?: string;
    readonly validUntil?: string;
}
export interface LaunchTemplateInstanceMarketOptions {
    readonly marketType?: string;
    /** spot_options block */
    readonly spotOptions?: LaunchTemplateInstanceMarketOptionsSpotOptions[];
}
export interface LaunchTemplateLicenseSpecification {
    readonly licenseConfigurationArn: string;
}
export interface LaunchTemplateMetadataOptions {
    readonly httpEndpoint?: string;
    readonly httpPutResponseHopLimit?: number;
    readonly httpTokens?: string;
}
export interface LaunchTemplateMonitoring {
    readonly enabled?: boolean;
}
export interface LaunchTemplateNetworkInterfaces {
    readonly associatePublicIpAddress?: string;
    readonly deleteOnTermination?: boolean;
    readonly description?: string;
    readonly deviceIndex?: number;
    readonly ipv4AddressCount?: number;
    readonly ipv4Addresses?: string[];
    readonly ipv6AddressCount?: number;
    readonly ipv6Addresses?: string[];
    readonly networkInterfaceId?: string;
    readonly privateIpAddress?: string;
    readonly securityGroups?: string[];
    readonly subnetId?: string;
}
export interface LaunchTemplatePlacement {
    readonly affinity?: string;
    readonly availabilityZone?: string;
    readonly groupName?: string;
    readonly hostId?: string;
    readonly partitionNumber?: number;
    readonly spreadDomain?: string;
    readonly tenancy?: string;
}
export interface LaunchTemplateTagSpecifications {
    readonly resourceType?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class LaunchTemplate extends TerraformResource {
    constructor(scope: Construct, id: string, config?: LaunchTemplateConfig);
    get arn(): string;
    private _defaultVersion?;
    get defaultVersion(): number | undefined;
    set defaultVersion(value: number | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _disableApiTermination?;
    get disableApiTermination(): boolean | undefined;
    set disableApiTermination(value: boolean | undefined);
    private _ebsOptimized?;
    get ebsOptimized(): string | undefined;
    set ebsOptimized(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _imageId?;
    get imageId(): string | undefined;
    set imageId(value: string | undefined);
    private _instanceInitiatedShutdownBehavior?;
    get instanceInitiatedShutdownBehavior(): string | undefined;
    set instanceInitiatedShutdownBehavior(value: string | undefined);
    private _instanceType?;
    get instanceType(): string | undefined;
    set instanceType(value: string | undefined);
    private _kernelId?;
    get kernelId(): string | undefined;
    set kernelId(value: string | undefined);
    private _keyName?;
    get keyName(): string | undefined;
    set keyName(value: string | undefined);
    get latestVersion(): number;
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _ramDiskId?;
    get ramDiskId(): string | undefined;
    set ramDiskId(value: string | undefined);
    private _securityGroupNames?;
    get securityGroupNames(): string[] | undefined;
    set securityGroupNames(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _updateDefaultVersion?;
    get updateDefaultVersion(): boolean | undefined;
    set updateDefaultVersion(value: boolean | undefined);
    private _userData?;
    get userData(): string | undefined;
    set userData(value: string | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _blockDeviceMappings?;
    get blockDeviceMappings(): LaunchTemplateBlockDeviceMappings[] | undefined;
    set blockDeviceMappings(value: LaunchTemplateBlockDeviceMappings[] | undefined);
    private _capacityReservationSpecification?;
    get capacityReservationSpecification(): LaunchTemplateCapacityReservationSpecification[] | undefined;
    set capacityReservationSpecification(value: LaunchTemplateCapacityReservationSpecification[] | undefined);
    private _cpuOptions?;
    get cpuOptions(): LaunchTemplateCpuOptions[] | undefined;
    set cpuOptions(value: LaunchTemplateCpuOptions[] | undefined);
    private _creditSpecification?;
    get creditSpecification(): LaunchTemplateCreditSpecification[] | undefined;
    set creditSpecification(value: LaunchTemplateCreditSpecification[] | undefined);
    private _elasticGpuSpecifications?;
    get elasticGpuSpecifications(): LaunchTemplateElasticGpuSpecifications[] | undefined;
    set elasticGpuSpecifications(value: LaunchTemplateElasticGpuSpecifications[] | undefined);
    private _elasticInferenceAccelerator?;
    get elasticInferenceAccelerator(): LaunchTemplateElasticInferenceAccelerator[] | undefined;
    set elasticInferenceAccelerator(value: LaunchTemplateElasticInferenceAccelerator[] | undefined);
    private _hibernationOptions?;
    get hibernationOptions(): LaunchTemplateHibernationOptions[] | undefined;
    set hibernationOptions(value: LaunchTemplateHibernationOptions[] | undefined);
    private _iamInstanceProfile?;
    get iamInstanceProfile(): LaunchTemplateIamInstanceProfile[] | undefined;
    set iamInstanceProfile(value: LaunchTemplateIamInstanceProfile[] | undefined);
    private _instanceMarketOptions?;
    get instanceMarketOptions(): LaunchTemplateInstanceMarketOptions[] | undefined;
    set instanceMarketOptions(value: LaunchTemplateInstanceMarketOptions[] | undefined);
    private _licenseSpecification?;
    get licenseSpecification(): LaunchTemplateLicenseSpecification[] | undefined;
    set licenseSpecification(value: LaunchTemplateLicenseSpecification[] | undefined);
    private _metadataOptions?;
    get metadataOptions(): LaunchTemplateMetadataOptions[] | undefined;
    set metadataOptions(value: LaunchTemplateMetadataOptions[] | undefined);
    private _monitoring?;
    get monitoring(): LaunchTemplateMonitoring[] | undefined;
    set monitoring(value: LaunchTemplateMonitoring[] | undefined);
    private _networkInterfaces?;
    get networkInterfaces(): LaunchTemplateNetworkInterfaces[] | undefined;
    set networkInterfaces(value: LaunchTemplateNetworkInterfaces[] | undefined);
    private _placement?;
    get placement(): LaunchTemplatePlacement[] | undefined;
    set placement(value: LaunchTemplatePlacement[] | undefined);
    private _tagSpecifications?;
    get tagSpecifications(): LaunchTemplateTagSpecifications[] | undefined;
    set tagSpecifications(value: LaunchTemplateTagSpecifications[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
