"use strict";
// https://www.terraform.io/docs/providers/aws/r/launch_template.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.LaunchTemplate = void 0;
const cdktf_1 = require("cdktf");
// Resource
class LaunchTemplate extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_launch_template',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._defaultVersion = config.defaultVersion;
        this._description = config.description;
        this._disableApiTermination = config.disableApiTermination;
        this._ebsOptimized = config.ebsOptimized;
        this._imageId = config.imageId;
        this._instanceInitiatedShutdownBehavior = config.instanceInitiatedShutdownBehavior;
        this._instanceType = config.instanceType;
        this._kernelId = config.kernelId;
        this._keyName = config.keyName;
        this._name = config.name;
        this._namePrefix = config.namePrefix;
        this._ramDiskId = config.ramDiskId;
        this._securityGroupNames = config.securityGroupNames;
        this._tags = config.tags;
        this._updateDefaultVersion = config.updateDefaultVersion;
        this._userData = config.userData;
        this._vpcSecurityGroupIds = config.vpcSecurityGroupIds;
        this._blockDeviceMappings = config.blockDeviceMappings;
        this._capacityReservationSpecification = config.capacityReservationSpecification;
        this._cpuOptions = config.cpuOptions;
        this._creditSpecification = config.creditSpecification;
        this._elasticGpuSpecifications = config.elasticGpuSpecifications;
        this._elasticInferenceAccelerator = config.elasticInferenceAccelerator;
        this._hibernationOptions = config.hibernationOptions;
        this._iamInstanceProfile = config.iamInstanceProfile;
        this._instanceMarketOptions = config.instanceMarketOptions;
        this._licenseSpecification = config.licenseSpecification;
        this._metadataOptions = config.metadataOptions;
        this._monitoring = config.monitoring;
        this._networkInterfaces = config.networkInterfaces;
        this._placement = config.placement;
        this._tagSpecifications = config.tagSpecifications;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get defaultVersion() {
        var _a;
        return (_a = this._defaultVersion) !== null && _a !== void 0 ? _a : this.getNumberAttribute('default_version');
    }
    set defaultVersion(value) {
        this._defaultVersion = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get disableApiTermination() {
        return this._disableApiTermination;
    }
    set disableApiTermination(value) {
        this._disableApiTermination = value;
    }
    get ebsOptimized() {
        return this._ebsOptimized;
    }
    set ebsOptimized(value) {
        this._ebsOptimized = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get imageId() {
        return this._imageId;
    }
    set imageId(value) {
        this._imageId = value;
    }
    get instanceInitiatedShutdownBehavior() {
        return this._instanceInitiatedShutdownBehavior;
    }
    set instanceInitiatedShutdownBehavior(value) {
        this._instanceInitiatedShutdownBehavior = value;
    }
    get instanceType() {
        return this._instanceType;
    }
    set instanceType(value) {
        this._instanceType = value;
    }
    get kernelId() {
        return this._kernelId;
    }
    set kernelId(value) {
        this._kernelId = value;
    }
    get keyName() {
        return this._keyName;
    }
    set keyName(value) {
        this._keyName = value;
    }
    // latest_version - computed: true, optional: false, required: true
    get latestVersion() {
        return this.getNumberAttribute('latest_version');
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get namePrefix() {
        return this._namePrefix;
    }
    set namePrefix(value) {
        this._namePrefix = value;
    }
    get ramDiskId() {
        return this._ramDiskId;
    }
    set ramDiskId(value) {
        this._ramDiskId = value;
    }
    get securityGroupNames() {
        return this._securityGroupNames;
    }
    set securityGroupNames(value) {
        this._securityGroupNames = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get updateDefaultVersion() {
        return this._updateDefaultVersion;
    }
    set updateDefaultVersion(value) {
        this._updateDefaultVersion = value;
    }
    get userData() {
        return this._userData;
    }
    set userData(value) {
        this._userData = value;
    }
    get vpcSecurityGroupIds() {
        return this._vpcSecurityGroupIds;
    }
    set vpcSecurityGroupIds(value) {
        this._vpcSecurityGroupIds = value;
    }
    get blockDeviceMappings() {
        return this._blockDeviceMappings;
    }
    set blockDeviceMappings(value) {
        this._blockDeviceMappings = value;
    }
    get capacityReservationSpecification() {
        return this._capacityReservationSpecification;
    }
    set capacityReservationSpecification(value) {
        this._capacityReservationSpecification = value;
    }
    get cpuOptions() {
        return this._cpuOptions;
    }
    set cpuOptions(value) {
        this._cpuOptions = value;
    }
    get creditSpecification() {
        return this._creditSpecification;
    }
    set creditSpecification(value) {
        this._creditSpecification = value;
    }
    get elasticGpuSpecifications() {
        return this._elasticGpuSpecifications;
    }
    set elasticGpuSpecifications(value) {
        this._elasticGpuSpecifications = value;
    }
    get elasticInferenceAccelerator() {
        return this._elasticInferenceAccelerator;
    }
    set elasticInferenceAccelerator(value) {
        this._elasticInferenceAccelerator = value;
    }
    get hibernationOptions() {
        return this._hibernationOptions;
    }
    set hibernationOptions(value) {
        this._hibernationOptions = value;
    }
    get iamInstanceProfile() {
        return this._iamInstanceProfile;
    }
    set iamInstanceProfile(value) {
        this._iamInstanceProfile = value;
    }
    get instanceMarketOptions() {
        return this._instanceMarketOptions;
    }
    set instanceMarketOptions(value) {
        this._instanceMarketOptions = value;
    }
    get licenseSpecification() {
        return this._licenseSpecification;
    }
    set licenseSpecification(value) {
        this._licenseSpecification = value;
    }
    get metadataOptions() {
        return this._metadataOptions;
    }
    set metadataOptions(value) {
        this._metadataOptions = value;
    }
    get monitoring() {
        return this._monitoring;
    }
    set monitoring(value) {
        this._monitoring = value;
    }
    get networkInterfaces() {
        return this._networkInterfaces;
    }
    set networkInterfaces(value) {
        this._networkInterfaces = value;
    }
    get placement() {
        return this._placement;
    }
    set placement(value) {
        this._placement = value;
    }
    get tagSpecifications() {
        return this._tagSpecifications;
    }
    set tagSpecifications(value) {
        this._tagSpecifications = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            default_version: this._defaultVersion,
            description: this._description,
            disable_api_termination: this._disableApiTermination,
            ebs_optimized: this._ebsOptimized,
            image_id: this._imageId,
            instance_initiated_shutdown_behavior: this._instanceInitiatedShutdownBehavior,
            instance_type: this._instanceType,
            kernel_id: this._kernelId,
            key_name: this._keyName,
            name: this._name,
            name_prefix: this._namePrefix,
            ram_disk_id: this._ramDiskId,
            security_group_names: this._securityGroupNames,
            tags: this._tags,
            update_default_version: this._updateDefaultVersion,
            user_data: this._userData,
            vpc_security_group_ids: this._vpcSecurityGroupIds,
            block_device_mappings: this._blockDeviceMappings,
            capacity_reservation_specification: this._capacityReservationSpecification,
            cpu_options: this._cpuOptions,
            credit_specification: this._creditSpecification,
            elastic_gpu_specifications: this._elasticGpuSpecifications,
            elastic_inference_accelerator: this._elasticInferenceAccelerator,
            hibernation_options: this._hibernationOptions,
            iam_instance_profile: this._iamInstanceProfile,
            instance_market_options: this._instanceMarketOptions,
            license_specification: this._licenseSpecification,
            metadata_options: this._metadataOptions,
            monitoring: this._monitoring,
            network_interfaces: this._networkInterfaces,
            placement: this._placement,
            tag_specifications: this._tagSpecifications,
        };
    }
}
exports.LaunchTemplate = LaunchTemplate;
//# sourceMappingURL=data:application/json;base64,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