import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LbListenerRuleConfig extends TerraformMetaArguments {
    readonly listenerArn: string;
    readonly priority?: number;
    /** action block */
    readonly action: LbListenerRuleAction[];
    /** condition block */
    readonly condition: LbListenerRuleCondition[];
}
export interface LbListenerRuleActionAuthenticateCognito {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly userPoolArn: string;
    readonly userPoolClientId: string;
    readonly userPoolDomain: string;
}
export interface LbListenerRuleActionAuthenticateOidc {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly authorizationEndpoint: string;
    readonly clientId: string;
    readonly clientSecret: string;
    readonly issuer: string;
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly tokenEndpoint: string;
    readonly userInfoEndpoint: string;
}
export interface LbListenerRuleActionFixedResponse {
    readonly contentType: string;
    readonly messageBody?: string;
    readonly statusCode?: string;
}
export interface LbListenerRuleActionForwardStickiness {
    readonly duration: number;
    readonly enabled?: boolean;
}
export interface LbListenerRuleActionForwardTargetGroup {
    readonly arn: string;
    readonly weight?: number;
}
export interface LbListenerRuleActionForward {
    /** stickiness block */
    readonly stickiness?: LbListenerRuleActionForwardStickiness[];
    /** target_group block */
    readonly targetGroup: LbListenerRuleActionForwardTargetGroup[];
}
export interface LbListenerRuleActionRedirect {
    readonly host?: string;
    readonly path?: string;
    readonly port?: string;
    readonly protocol?: string;
    readonly query?: string;
    readonly statusCode: string;
}
export interface LbListenerRuleAction {
    readonly order?: number;
    readonly targetGroupArn?: string;
    readonly type: string;
    /** authenticate_cognito block */
    readonly authenticateCognito?: LbListenerRuleActionAuthenticateCognito[];
    /** authenticate_oidc block */
    readonly authenticateOidc?: LbListenerRuleActionAuthenticateOidc[];
    /** fixed_response block */
    readonly fixedResponse?: LbListenerRuleActionFixedResponse[];
    /** forward block */
    readonly forward?: LbListenerRuleActionForward[];
    /** redirect block */
    readonly redirect?: LbListenerRuleActionRedirect[];
}
export interface LbListenerRuleConditionHostHeader {
    readonly values?: string[];
}
export interface LbListenerRuleConditionHttpHeader {
    readonly httpHeaderName: string;
    readonly values: string[];
}
export interface LbListenerRuleConditionHttpRequestMethod {
    readonly values: string[];
}
export interface LbListenerRuleConditionPathPattern {
    readonly values?: string[];
}
export interface LbListenerRuleConditionQueryString {
    readonly key?: string;
    readonly value: string;
}
export interface LbListenerRuleConditionSourceIp {
    readonly values: string[];
}
export interface LbListenerRuleCondition {
    readonly field?: string;
    readonly values?: string[];
    /** host_header block */
    readonly hostHeader?: LbListenerRuleConditionHostHeader[];
    /** http_header block */
    readonly httpHeader?: LbListenerRuleConditionHttpHeader[];
    /** http_request_method block */
    readonly httpRequestMethod?: LbListenerRuleConditionHttpRequestMethod[];
    /** path_pattern block */
    readonly pathPattern?: LbListenerRuleConditionPathPattern[];
    /** query_string block */
    readonly queryString?: LbListenerRuleConditionQueryString[];
    /** source_ip block */
    readonly sourceIp?: LbListenerRuleConditionSourceIp[];
}
export declare class LbListenerRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: LbListenerRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _listenerArn;
    get listenerArn(): string;
    set listenerArn(value: string);
    private _priority?;
    get priority(): number | undefined;
    set priority(value: number | undefined);
    private _action;
    get action(): LbListenerRuleAction[];
    set action(value: LbListenerRuleAction[]);
    private _condition;
    get condition(): LbListenerRuleCondition[];
    set condition(value: LbListenerRuleCondition[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
