import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LbListenerConfig extends TerraformMetaArguments {
    readonly certificateArn?: string;
    readonly loadBalancerArn: string;
    readonly port: number;
    readonly protocol?: string;
    readonly sslPolicy?: string;
    /** default_action block */
    readonly defaultAction: LbListenerDefaultAction[];
    /** timeouts block */
    readonly timeouts?: LbListenerTimeouts;
}
export interface LbListenerDefaultActionAuthenticateCognito {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly userPoolArn: string;
    readonly userPoolClientId: string;
    readonly userPoolDomain: string;
}
export interface LbListenerDefaultActionAuthenticateOidc {
    readonly authenticationRequestExtraParams?: {
        [key: string]: string;
    };
    readonly authorizationEndpoint: string;
    readonly clientId: string;
    readonly clientSecret: string;
    readonly issuer: string;
    readonly onUnauthenticatedRequest?: string;
    readonly scope?: string;
    readonly sessionCookieName?: string;
    readonly sessionTimeout?: number;
    readonly tokenEndpoint: string;
    readonly userInfoEndpoint: string;
}
export interface LbListenerDefaultActionFixedResponse {
    readonly contentType: string;
    readonly messageBody?: string;
    readonly statusCode?: string;
}
export interface LbListenerDefaultActionForwardStickiness {
    readonly duration: number;
    readonly enabled?: boolean;
}
export interface LbListenerDefaultActionForwardTargetGroup {
    readonly arn: string;
    readonly weight?: number;
}
export interface LbListenerDefaultActionForward {
    /** stickiness block */
    readonly stickiness?: LbListenerDefaultActionForwardStickiness[];
    /** target_group block */
    readonly targetGroup: LbListenerDefaultActionForwardTargetGroup[];
}
export interface LbListenerDefaultActionRedirect {
    readonly host?: string;
    readonly path?: string;
    readonly port?: string;
    readonly protocol?: string;
    readonly query?: string;
    readonly statusCode: string;
}
export interface LbListenerDefaultAction {
    readonly order?: number;
    readonly targetGroupArn?: string;
    readonly type: string;
    /** authenticate_cognito block */
    readonly authenticateCognito?: LbListenerDefaultActionAuthenticateCognito[];
    /** authenticate_oidc block */
    readonly authenticateOidc?: LbListenerDefaultActionAuthenticateOidc[];
    /** fixed_response block */
    readonly fixedResponse?: LbListenerDefaultActionFixedResponse[];
    /** forward block */
    readonly forward?: LbListenerDefaultActionForward[];
    /** redirect block */
    readonly redirect?: LbListenerDefaultActionRedirect[];
}
export interface LbListenerTimeouts {
    readonly read?: string;
}
export declare class LbListener extends TerraformResource {
    constructor(scope: Construct, id: string, config: LbListenerConfig);
    get arn(): string;
    private _certificateArn?;
    get certificateArn(): string | undefined;
    set certificateArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _loadBalancerArn;
    get loadBalancerArn(): string;
    set loadBalancerArn(value: string);
    private _port;
    get port(): number;
    set port(value: number);
    private _protocol?;
    get protocol(): string | undefined;
    set protocol(value: string | undefined);
    private _sslPolicy?;
    get sslPolicy(): string | undefined;
    set sslPolicy(value: string | undefined);
    private _defaultAction;
    get defaultAction(): LbListenerDefaultAction[];
    set defaultAction(value: LbListenerDefaultAction[]);
    private _timeouts?;
    get timeouts(): LbListenerTimeouts | undefined;
    set timeouts(value: LbListenerTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
