import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LbConfig extends TerraformMetaArguments {
    readonly dropInvalidHeaderFields?: boolean;
    readonly enableCrossZoneLoadBalancing?: boolean;
    readonly enableDeletionProtection?: boolean;
    readonly enableHttp2?: boolean;
    readonly idleTimeout?: number;
    readonly internal?: boolean;
    readonly ipAddressType?: string;
    readonly loadBalancerType?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly securityGroups?: string[];
    readonly subnets?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** access_logs block */
    readonly accessLogs?: LbAccessLogs[];
    /** subnet_mapping block */
    readonly subnetMapping?: LbSubnetMapping[];
    /** timeouts block */
    readonly timeouts?: LbTimeouts;
}
export interface LbAccessLogs {
    readonly bucket: string;
    readonly enabled?: boolean;
    readonly prefix?: string;
}
export interface LbSubnetMapping {
    readonly allocationId?: string;
    readonly subnetId: string;
}
export interface LbTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class Lb extends TerraformResource {
    constructor(scope: Construct, id: string, config?: LbConfig);
    get arn(): string;
    get arnSuffix(): string;
    get dnsName(): string;
    private _dropInvalidHeaderFields?;
    get dropInvalidHeaderFields(): boolean | undefined;
    set dropInvalidHeaderFields(value: boolean | undefined);
    private _enableCrossZoneLoadBalancing?;
    get enableCrossZoneLoadBalancing(): boolean | undefined;
    set enableCrossZoneLoadBalancing(value: boolean | undefined);
    private _enableDeletionProtection?;
    get enableDeletionProtection(): boolean | undefined;
    set enableDeletionProtection(value: boolean | undefined);
    private _enableHttp2?;
    get enableHttp2(): boolean | undefined;
    set enableHttp2(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _idleTimeout?;
    get idleTimeout(): number | undefined;
    set idleTimeout(value: number | undefined);
    private _internal?;
    get internal(): boolean | undefined;
    set internal(value: boolean | undefined);
    private _ipAddressType?;
    get ipAddressType(): string | undefined;
    set ipAddressType(value: string | undefined);
    private _loadBalancerType?;
    get loadBalancerType(): string | undefined;
    set loadBalancerType(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _subnets?;
    get subnets(): string[] | undefined;
    set subnets(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    get zoneId(): string;
    private _accessLogs?;
    get accessLogs(): LbAccessLogs[] | undefined;
    set accessLogs(value: LbAccessLogs[] | undefined);
    private _subnetMapping?;
    get subnetMapping(): LbSubnetMapping[] | undefined;
    set subnetMapping(value: LbSubnetMapping[] | undefined);
    private _timeouts?;
    get timeouts(): LbTimeouts | undefined;
    set timeouts(value: LbTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
