"use strict";
// https://www.terraform.io/docs/providers/aws/r/licensemanager_license_configuration.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicensemanagerLicenseConfiguration = void 0;
const cdktf_1 = require("cdktf");
// Resource
class LicensemanagerLicenseConfiguration extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_licensemanager_license_configuration',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._description = config.description;
        this._licenseCount = config.licenseCount;
        this._licenseCountHardLimit = config.licenseCountHardLimit;
        this._licenseCountingType = config.licenseCountingType;
        this._licenseRules = config.licenseRules;
        this._name = config.name;
        this._tags = config.tags;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get licenseCount() {
        return this._licenseCount;
    }
    set licenseCount(value) {
        this._licenseCount = value;
    }
    get licenseCountHardLimit() {
        return this._licenseCountHardLimit;
    }
    set licenseCountHardLimit(value) {
        this._licenseCountHardLimit = value;
    }
    get licenseCountingType() {
        return this._licenseCountingType;
    }
    set licenseCountingType(value) {
        this._licenseCountingType = value;
    }
    get licenseRules() {
        return this._licenseRules;
    }
    set licenseRules(value) {
        this._licenseRules = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: this._description,
            license_count: this._licenseCount,
            license_count_hard_limit: this._licenseCountHardLimit,
            license_counting_type: this._licenseCountingType,
            license_rules: this._licenseRules,
            name: this._name,
            tags: this._tags,
        };
    }
}
exports.LicensemanagerLicenseConfiguration = LicensemanagerLicenseConfiguration;
//# sourceMappingURL=data:application/json;base64,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