import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LightsailInstanceConfig extends TerraformMetaArguments {
    readonly availabilityZone: string;
    readonly blueprintId: string;
    readonly bundleId: string;
    readonly keyPairName?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly userData?: string;
}
export declare class LightsailInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: LightsailInstanceConfig);
    get arn(): string;
    private _availabilityZone;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    private _blueprintId;
    get blueprintId(): string;
    set blueprintId(value: string);
    private _bundleId;
    get bundleId(): string;
    set bundleId(value: string);
    get cpuCount(): number;
    get createdAt(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ipv6Address(): string;
    get isStaticIp(): boolean;
    private _keyPairName?;
    get keyPairName(): string | undefined;
    set keyPairName(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get privateIpAddress(): string;
    get publicIpAddress(): string;
    get ramSize(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _userData?;
    get userData(): string | undefined;
    set userData(value: string | undefined);
    get username(): string;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
