import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface LightsailKeyPairConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly namePrefix?: string;
    readonly pgpKey?: string;
    readonly publicKey?: string;
}
export declare class LightsailKeyPair extends TerraformResource {
    constructor(scope: Construct, id: string, config?: LightsailKeyPairConfig);
    get arn(): string;
    get encryptedFingerprint(): string;
    get encryptedPrivateKey(): string;
    get fingerprint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _pgpKey?;
    get pgpKey(): string | undefined;
    set pgpKey(value: string | undefined);
    get privateKey(): string;
    private _publicKey?;
    get publicKey(): string | undefined;
    set publicKey(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
