import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MacieS3BucketAssociationConfig extends TerraformMetaArguments {
    readonly bucketName: string;
    readonly memberAccountId?: string;
    readonly prefix?: string;
    /** classification_type block */
    readonly classificationType?: MacieS3BucketAssociationClassificationType[];
}
export interface MacieS3BucketAssociationClassificationType {
    readonly continuous?: string;
    readonly oneTime?: string;
}
export declare class MacieS3BucketAssociation extends TerraformResource {
    constructor(scope: Construct, id: string, config: MacieS3BucketAssociationConfig);
    private _bucketName;
    get bucketName(): string;
    set bucketName(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _memberAccountId?;
    get memberAccountId(): string | undefined;
    set memberAccountId(value: string | undefined);
    private _prefix?;
    get prefix(): string | undefined;
    set prefix(value: string | undefined);
    private _classificationType?;
    get classificationType(): MacieS3BucketAssociationClassificationType[] | undefined;
    set classificationType(value: MacieS3BucketAssociationClassificationType[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
