import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MediaConvertQueueConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly pricingPlan?: string;
    readonly status?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** reservation_plan_settings block */
    readonly reservationPlanSettings?: MediaConvertQueueReservationPlanSettings[];
}
export interface MediaConvertQueueReservationPlanSettings {
    readonly commitment: string;
    readonly renewalType: string;
    readonly reservedSlots: number;
}
export declare class MediaConvertQueue extends TerraformResource {
    constructor(scope: Construct, id: string, config: MediaConvertQueueConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _pricingPlan?;
    get pricingPlan(): string | undefined;
    set pricingPlan(value: string | undefined);
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _reservationPlanSettings?;
    get reservationPlanSettings(): MediaConvertQueueReservationPlanSettings[] | undefined;
    set reservationPlanSettings(value: MediaConvertQueueReservationPlanSettings[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
