import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface MediaPackageChannelConfig extends TerraformMetaArguments {
    readonly channelId: string;
    readonly description?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class MediaPackageChannelHlsIngestIngestEndpoints extends ComplexComputedList {
    get password(): string;
    get url(): string;
    get username(): string;
}
export declare class MediaPackageChannelHlsIngest extends ComplexComputedList {
    get ingestEndpoints(): any;
}
export declare class MediaPackageChannel extends TerraformResource {
    constructor(scope: Construct, id: string, config: MediaPackageChannelConfig);
    get arn(): string;
    private _channelId;
    get channelId(): string;
    set channelId(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    hlsIngest(index: string): MediaPackageChannelHlsIngest;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
