import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MediaStoreContainerConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class MediaStoreContainer extends TerraformResource {
    constructor(scope: Construct, id: string, config: MediaStoreContainerConfig);
    get arn(): string;
    get endpoint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
