import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface MqBrokerConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly brokerName: string;
    readonly deploymentMode?: string;
    readonly engineType: string;
    readonly engineVersion: string;
    readonly hostInstanceType: string;
    readonly publiclyAccessible?: boolean;
    readonly securityGroups: string[];
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** configuration block */
    readonly configuration?: MqBrokerConfiguration[];
    /** encryption_options block */
    readonly encryptionOptions?: MqBrokerEncryptionOptions[];
    /** logs block */
    readonly logs?: MqBrokerLogs[];
    /** maintenance_window_start_time block */
    readonly maintenanceWindowStartTime?: MqBrokerMaintenanceWindowStartTime[];
    /** user block */
    readonly user: MqBrokerUser[];
}
export declare class MqBrokerInstances extends ComplexComputedList {
    get consoleUrl(): string;
    get endpoints(): string[];
    get ipAddress(): string;
}
export interface MqBrokerConfiguration {
    readonly id?: string;
    readonly revision?: number;
}
export interface MqBrokerEncryptionOptions {
    readonly kmsKeyId?: string;
    readonly useAwsOwnedKey?: boolean;
}
export interface MqBrokerLogs {
    readonly audit?: boolean;
    readonly general?: boolean;
}
export interface MqBrokerMaintenanceWindowStartTime {
    readonly dayOfWeek: string;
    readonly timeOfDay: string;
    readonly timeZone: string;
}
export interface MqBrokerUser {
    readonly consoleAccess?: boolean;
    readonly groups?: string[];
    readonly password: string;
    readonly username: string;
}
export declare class MqBroker extends TerraformResource {
    constructor(scope: Construct, id: string, config: MqBrokerConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _brokerName;
    get brokerName(): string;
    set brokerName(value: string);
    private _deploymentMode?;
    get deploymentMode(): string | undefined;
    set deploymentMode(value: string | undefined);
    private _engineType;
    get engineType(): string;
    set engineType(value: string);
    private _engineVersion;
    get engineVersion(): string;
    set engineVersion(value: string);
    private _hostInstanceType;
    get hostInstanceType(): string;
    set hostInstanceType(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    instances(index: string): MqBrokerInstances;
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    private _securityGroups;
    get securityGroups(): string[];
    set securityGroups(value: string[]);
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _configuration?;
    get configuration(): MqBrokerConfiguration[] | undefined;
    set configuration(value: MqBrokerConfiguration[] | undefined);
    private _encryptionOptions?;
    get encryptionOptions(): MqBrokerEncryptionOptions[] | undefined;
    set encryptionOptions(value: MqBrokerEncryptionOptions[] | undefined);
    private _logs?;
    get logs(): MqBrokerLogs[] | undefined;
    set logs(value: MqBrokerLogs[] | undefined);
    private _maintenanceWindowStartTime?;
    get maintenanceWindowStartTime(): MqBrokerMaintenanceWindowStartTime[] | undefined;
    set maintenanceWindowStartTime(value: MqBrokerMaintenanceWindowStartTime[] | undefined);
    private _user;
    get user(): MqBrokerUser[];
    set user(value: MqBrokerUser[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
