import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MqConfigurationConfig extends TerraformMetaArguments {
    readonly data: string;
    readonly description?: string;
    readonly engineType: string;
    readonly engineVersion: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class MqConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: MqConfigurationConfig);
    get arn(): string;
    private _data;
    get data(): string;
    set data(value: string);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _engineType;
    get engineType(): string;
    set engineType(value: string);
    private _engineVersion;
    get engineVersion(): string;
    set engineVersion(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get latestRevision(): number;
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
