import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MskClusterConfig extends TerraformMetaArguments {
    readonly clusterName: string;
    readonly enhancedMonitoring?: string;
    readonly kafkaVersion: string;
    readonly numberOfBrokerNodes: number;
    readonly tags?: {
        [key: string]: string;
    };
    /** broker_node_group_info block */
    readonly brokerNodeGroupInfo: MskClusterBrokerNodeGroupInfo[];
    /** client_authentication block */
    readonly clientAuthentication?: MskClusterClientAuthentication[];
    /** configuration_info block */
    readonly configurationInfo?: MskClusterConfigurationInfo[];
    /** encryption_info block */
    readonly encryptionInfo?: MskClusterEncryptionInfo[];
    /** logging_info block */
    readonly loggingInfo?: MskClusterLoggingInfo[];
    /** open_monitoring block */
    readonly openMonitoring?: MskClusterOpenMonitoring[];
}
export interface MskClusterBrokerNodeGroupInfo {
    readonly azDistribution?: string;
    readonly clientSubnets: string[];
    readonly ebsVolumeSize: number;
    readonly instanceType: string;
    readonly securityGroups: string[];
}
export interface MskClusterClientAuthenticationTls {
    readonly certificateAuthorityArns?: string[];
}
export interface MskClusterClientAuthentication {
    /** tls block */
    readonly tls?: MskClusterClientAuthenticationTls[];
}
export interface MskClusterConfigurationInfo {
    readonly arn: string;
    readonly revision: number;
}
export interface MskClusterEncryptionInfoEncryptionInTransit {
    readonly clientBroker?: string;
    readonly inCluster?: boolean;
}
export interface MskClusterEncryptionInfo {
    readonly encryptionAtRestKmsKeyArn?: string;
    /** encryption_in_transit block */
    readonly encryptionInTransit?: MskClusterEncryptionInfoEncryptionInTransit[];
}
export interface MskClusterLoggingInfoBrokerLogsCloudwatchLogs {
    readonly enabled: boolean;
    readonly logGroup?: string;
}
export interface MskClusterLoggingInfoBrokerLogsFirehose {
    readonly deliveryStream?: string;
    readonly enabled: boolean;
}
export interface MskClusterLoggingInfoBrokerLogsS3 {
    readonly bucket?: string;
    readonly enabled: boolean;
    readonly prefix?: string;
}
export interface MskClusterLoggingInfoBrokerLogs {
    /** cloudwatch_logs block */
    readonly cloudwatchLogs?: MskClusterLoggingInfoBrokerLogsCloudwatchLogs[];
    /** firehose block */
    readonly firehose?: MskClusterLoggingInfoBrokerLogsFirehose[];
    /** s3 block */
    readonly s3?: MskClusterLoggingInfoBrokerLogsS3[];
}
export interface MskClusterLoggingInfo {
    /** broker_logs block */
    readonly brokerLogs: MskClusterLoggingInfoBrokerLogs[];
}
export interface MskClusterOpenMonitoringPrometheusJmxExporter {
    readonly enabledInBroker: boolean;
}
export interface MskClusterOpenMonitoringPrometheusNodeExporter {
    readonly enabledInBroker: boolean;
}
export interface MskClusterOpenMonitoringPrometheus {
    /** jmx_exporter block */
    readonly jmxExporter?: MskClusterOpenMonitoringPrometheusJmxExporter[];
    /** node_exporter block */
    readonly nodeExporter?: MskClusterOpenMonitoringPrometheusNodeExporter[];
}
export interface MskClusterOpenMonitoring {
    /** prometheus block */
    readonly prometheus: MskClusterOpenMonitoringPrometheus[];
}
export declare class MskCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: MskClusterConfig);
    get arn(): string;
    get bootstrapBrokers(): string;
    get bootstrapBrokersTls(): string;
    private _clusterName;
    get clusterName(): string;
    set clusterName(value: string);
    get currentVersion(): string;
    private _enhancedMonitoring?;
    get enhancedMonitoring(): string | undefined;
    set enhancedMonitoring(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kafkaVersion;
    get kafkaVersion(): string;
    set kafkaVersion(value: string);
    private _numberOfBrokerNodes;
    get numberOfBrokerNodes(): number;
    set numberOfBrokerNodes(value: number);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get zookeeperConnectString(): string;
    private _brokerNodeGroupInfo;
    get brokerNodeGroupInfo(): MskClusterBrokerNodeGroupInfo[];
    set brokerNodeGroupInfo(value: MskClusterBrokerNodeGroupInfo[]);
    private _clientAuthentication?;
    get clientAuthentication(): MskClusterClientAuthentication[] | undefined;
    set clientAuthentication(value: MskClusterClientAuthentication[] | undefined);
    private _configurationInfo?;
    get configurationInfo(): MskClusterConfigurationInfo[] | undefined;
    set configurationInfo(value: MskClusterConfigurationInfo[] | undefined);
    private _encryptionInfo?;
    get encryptionInfo(): MskClusterEncryptionInfo[] | undefined;
    set encryptionInfo(value: MskClusterEncryptionInfo[] | undefined);
    private _loggingInfo?;
    get loggingInfo(): MskClusterLoggingInfo[] | undefined;
    set loggingInfo(value: MskClusterLoggingInfo[] | undefined);
    private _openMonitoring?;
    get openMonitoring(): MskClusterOpenMonitoring[] | undefined;
    set openMonitoring(value: MskClusterOpenMonitoring[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
