"use strict";
// https://www.terraform.io/docs/providers/aws/r/msk_cluster.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.MskCluster = void 0;
const cdktf_1 = require("cdktf");
// Resource
class MskCluster extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_msk_cluster',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._clusterName = config.clusterName;
        this._enhancedMonitoring = config.enhancedMonitoring;
        this._kafkaVersion = config.kafkaVersion;
        this._numberOfBrokerNodes = config.numberOfBrokerNodes;
        this._tags = config.tags;
        this._brokerNodeGroupInfo = config.brokerNodeGroupInfo;
        this._clientAuthentication = config.clientAuthentication;
        this._configurationInfo = config.configurationInfo;
        this._encryptionInfo = config.encryptionInfo;
        this._loggingInfo = config.loggingInfo;
        this._openMonitoring = config.openMonitoring;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    // bootstrap_brokers - computed: true, optional: false, required: true
    get bootstrapBrokers() {
        return this.getStringAttribute('bootstrap_brokers');
    }
    // bootstrap_brokers_tls - computed: true, optional: false, required: true
    get bootstrapBrokersTls() {
        return this.getStringAttribute('bootstrap_brokers_tls');
    }
    get clusterName() {
        return this._clusterName;
    }
    set clusterName(value) {
        this._clusterName = value;
    }
    // current_version - computed: true, optional: false, required: true
    get currentVersion() {
        return this.getStringAttribute('current_version');
    }
    get enhancedMonitoring() {
        return this._enhancedMonitoring;
    }
    set enhancedMonitoring(value) {
        this._enhancedMonitoring = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get kafkaVersion() {
        return this._kafkaVersion;
    }
    set kafkaVersion(value) {
        this._kafkaVersion = value;
    }
    get numberOfBrokerNodes() {
        return this._numberOfBrokerNodes;
    }
    set numberOfBrokerNodes(value) {
        this._numberOfBrokerNodes = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    // zookeeper_connect_string - computed: true, optional: false, required: true
    get zookeeperConnectString() {
        return this.getStringAttribute('zookeeper_connect_string');
    }
    get brokerNodeGroupInfo() {
        return this._brokerNodeGroupInfo;
    }
    set brokerNodeGroupInfo(value) {
        this._brokerNodeGroupInfo = value;
    }
    get clientAuthentication() {
        return this._clientAuthentication;
    }
    set clientAuthentication(value) {
        this._clientAuthentication = value;
    }
    get configurationInfo() {
        return this._configurationInfo;
    }
    set configurationInfo(value) {
        this._configurationInfo = value;
    }
    get encryptionInfo() {
        return this._encryptionInfo;
    }
    set encryptionInfo(value) {
        this._encryptionInfo = value;
    }
    get loggingInfo() {
        return this._loggingInfo;
    }
    set loggingInfo(value) {
        this._loggingInfo = value;
    }
    get openMonitoring() {
        return this._openMonitoring;
    }
    set openMonitoring(value) {
        this._openMonitoring = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            cluster_name: this._clusterName,
            enhanced_monitoring: this._enhancedMonitoring,
            kafka_version: this._kafkaVersion,
            number_of_broker_nodes: this._numberOfBrokerNodes,
            tags: this._tags,
            broker_node_group_info: this._brokerNodeGroupInfo,
            client_authentication: this._clientAuthentication,
            configuration_info: this._configurationInfo,
            encryption_info: this._encryptionInfo,
            logging_info: this._loggingInfo,
            open_monitoring: this._openMonitoring,
        };
    }
}
exports.MskCluster = MskCluster;
//# sourceMappingURL=data:application/json;base64,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