import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface MskConfigurationConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly kafkaVersions: string[];
    readonly name: string;
    readonly serverProperties: string;
}
export declare class MskConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: MskConfigurationConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kafkaVersions;
    get kafkaVersions(): string[];
    set kafkaVersions(value: string[]);
    get latestRevision(): number;
    private _name;
    get name(): string;
    set name(value: string);
    private _serverProperties;
    get serverProperties(): string;
    set serverProperties(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
