import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NatGatewayConfig extends TerraformMetaArguments {
    readonly allocationId: string;
    readonly subnetId: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class NatGateway extends TerraformResource {
    constructor(scope: Construct, id: string, config: NatGatewayConfig);
    private _allocationId;
    get allocationId(): string;
    set allocationId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get networkInterfaceId(): string;
    get privateIp(): string;
    get publicIp(): string;
    private _subnetId;
    get subnetId(): string;
    set subnetId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
