import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NeptuneClusterInstanceConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly availabilityZone?: string;
    readonly clusterIdentifier: string;
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly identifier?: string;
    readonly identifierPrefix?: string;
    readonly instanceClass: string;
    readonly neptuneParameterGroupName?: string;
    readonly neptuneSubnetGroupName?: string;
    readonly port?: number;
    readonly preferredBackupWindow?: string;
    readonly preferredMaintenanceWindow?: string;
    readonly promotionTier?: number;
    readonly publiclyAccessible?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: NeptuneClusterInstanceTimeouts;
}
export interface NeptuneClusterInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class NeptuneClusterInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: NeptuneClusterInstanceConfig);
    get address(): string;
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    get dbiResourceId(): string;
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identifier?;
    get identifier(): string | undefined;
    set identifier(value: string | undefined);
    private _identifierPrefix?;
    get identifierPrefix(): string | undefined;
    set identifierPrefix(value: string | undefined);
    private _instanceClass;
    get instanceClass(): string;
    set instanceClass(value: string);
    get kmsKeyArn(): string;
    private _neptuneParameterGroupName?;
    get neptuneParameterGroupName(): string | undefined;
    set neptuneParameterGroupName(value: string | undefined);
    private _neptuneSubnetGroupName?;
    get neptuneSubnetGroupName(): string | undefined;
    set neptuneSubnetGroupName(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredBackupWindow?;
    get preferredBackupWindow(): string | undefined;
    set preferredBackupWindow(value: string | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    private _promotionTier?;
    get promotionTier(): number | undefined;
    set promotionTier(value: number | undefined);
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get writer(): boolean;
    private _timeouts?;
    get timeouts(): NeptuneClusterInstanceTimeouts | undefined;
    set timeouts(value: NeptuneClusterInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
