import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NeptuneClusterConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly availabilityZones?: string[];
    readonly backupRetentionPeriod?: number;
    readonly clusterIdentifier?: string;
    readonly clusterIdentifierPrefix?: string;
    readonly deletionProtection?: boolean;
    readonly enableCloudwatchLogsExports?: string[];
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly finalSnapshotIdentifier?: string;
    readonly iamDatabaseAuthenticationEnabled?: boolean;
    readonly iamRoles?: string[];
    readonly kmsKeyArn?: string;
    readonly neptuneClusterParameterGroupName?: string;
    readonly neptuneSubnetGroupName?: string;
    readonly port?: number;
    readonly preferredBackupWindow?: string;
    readonly preferredMaintenanceWindow?: string;
    readonly replicationSourceIdentifier?: string;
    readonly skipFinalSnapshot?: boolean;
    readonly snapshotIdentifier?: string;
    readonly storageEncrypted?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** timeouts block */
    readonly timeouts?: NeptuneClusterTimeouts;
}
export interface NeptuneClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class NeptuneCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config?: NeptuneClusterConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _backupRetentionPeriod?;
    get backupRetentionPeriod(): number | undefined;
    set backupRetentionPeriod(value: number | undefined);
    private _clusterIdentifier?;
    get clusterIdentifier(): string | undefined;
    set clusterIdentifier(value: string | undefined);
    private _clusterIdentifierPrefix?;
    get clusterIdentifierPrefix(): string | undefined;
    set clusterIdentifierPrefix(value: string | undefined);
    get clusterMembers(): string[];
    get clusterResourceId(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | undefined;
    set deletionProtection(value: boolean | undefined);
    private _enableCloudwatchLogsExports?;
    get enableCloudwatchLogsExports(): string[] | undefined;
    set enableCloudwatchLogsExports(value: string[] | undefined);
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _finalSnapshotIdentifier?;
    get finalSnapshotIdentifier(): string | undefined;
    set finalSnapshotIdentifier(value: string | undefined);
    get hostedZoneId(): string;
    private _iamDatabaseAuthenticationEnabled?;
    get iamDatabaseAuthenticationEnabled(): boolean | undefined;
    set iamDatabaseAuthenticationEnabled(value: boolean | undefined);
    private _iamRoles?;
    get iamRoles(): string[] | undefined;
    set iamRoles(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _neptuneClusterParameterGroupName?;
    get neptuneClusterParameterGroupName(): string | undefined;
    set neptuneClusterParameterGroupName(value: string | undefined);
    private _neptuneSubnetGroupName?;
    get neptuneSubnetGroupName(): string | undefined;
    set neptuneSubnetGroupName(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredBackupWindow?;
    get preferredBackupWindow(): string | undefined;
    set preferredBackupWindow(value: string | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    get readerEndpoint(): string;
    private _replicationSourceIdentifier?;
    get replicationSourceIdentifier(): string | undefined;
    set replicationSourceIdentifier(value: string | undefined);
    private _skipFinalSnapshot?;
    get skipFinalSnapshot(): boolean | undefined;
    set skipFinalSnapshot(value: boolean | undefined);
    private _snapshotIdentifier?;
    get snapshotIdentifier(): string | undefined;
    set snapshotIdentifier(value: string | undefined);
    private _storageEncrypted?;
    get storageEncrypted(): boolean | undefined;
    set storageEncrypted(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _timeouts?;
    get timeouts(): NeptuneClusterTimeouts | undefined;
    set timeouts(value: NeptuneClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
