import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NeptuneEventSubscriptionConfig extends TerraformMetaArguments {
    readonly enabled?: boolean;
    readonly eventCategories?: string[];
    readonly name?: string;
    readonly namePrefix?: string;
    readonly snsTopicArn: string;
    readonly sourceIds?: string[];
    readonly sourceType?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: NeptuneEventSubscriptionTimeouts;
}
export interface NeptuneEventSubscriptionTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class NeptuneEventSubscription extends TerraformResource {
    constructor(scope: Construct, id: string, config: NeptuneEventSubscriptionConfig);
    get arn(): string;
    get customerAwsId(): string;
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _eventCategories?;
    get eventCategories(): string[] | undefined;
    set eventCategories(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _snsTopicArn;
    get snsTopicArn(): string;
    set snsTopicArn(value: string);
    private _sourceIds?;
    get sourceIds(): string[] | undefined;
    set sourceIds(value: string[] | undefined);
    private _sourceType?;
    get sourceType(): string | undefined;
    set sourceType(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): NeptuneEventSubscriptionTimeouts | undefined;
    set timeouts(value: NeptuneEventSubscriptionTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
