import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NetworkAclConfig extends TerraformMetaArguments {
    readonly egress?: NetworkAclEgress[];
    readonly ingress?: NetworkAclIngress[];
    readonly subnetId?: string;
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId: string;
}
export interface NetworkAclEgress {
    readonly action?: string;
    readonly cidrBlock?: string;
    readonly fromPort?: number;
    readonly icmpCode?: number;
    readonly icmpType?: number;
    readonly ipv6CidrBlock?: string;
    readonly protocol?: string;
    readonly ruleNo?: number;
    readonly toPort?: number;
}
export interface NetworkAclIngress {
    readonly action?: string;
    readonly cidrBlock?: string;
    readonly fromPort?: number;
    readonly icmpCode?: number;
    readonly icmpType?: number;
    readonly ipv6CidrBlock?: string;
    readonly protocol?: string;
    readonly ruleNo?: number;
    readonly toPort?: number;
}
export declare class NetworkAcl extends TerraformResource {
    constructor(scope: Construct, id: string, config: NetworkAclConfig);
    get arn(): string;
    private _egress?;
    get egress(): NetworkAclEgress[] | undefined;
    set egress(value: NetworkAclEgress[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ingress?;
    get ingress(): NetworkAclIngress[] | undefined;
    set ingress(value: NetworkAclIngress[] | undefined);
    get ownerId(): string;
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
