import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface NetworkInterfaceConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly privateIp?: string;
    readonly privateIps?: string[];
    readonly privateIpsCount?: number;
    readonly securityGroups?: string[];
    readonly sourceDestCheck?: boolean;
    readonly subnetId: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** attachment block */
    readonly attachment?: NetworkInterfaceAttachment[];
}
export interface NetworkInterfaceAttachment {
    readonly deviceIndex: number;
    readonly instance: string;
}
export declare class NetworkInterface extends TerraformResource {
    constructor(scope: Construct, id: string, config: NetworkInterfaceConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get macAddress(): string;
    get outpostArn(): string;
    get privateDnsName(): string;
    private _privateIp?;
    get privateIp(): string | undefined;
    set privateIp(value: string | undefined);
    private _privateIps?;
    get privateIps(): string[] | undefined;
    set privateIps(value: string[] | undefined);
    private _privateIpsCount?;
    get privateIpsCount(): number | undefined;
    set privateIpsCount(value: number | undefined);
    private _securityGroups?;
    get securityGroups(): string[] | undefined;
    set securityGroups(value: string[] | undefined);
    private _sourceDestCheck?;
    get sourceDestCheck(): boolean | undefined;
    set sourceDestCheck(value: boolean | undefined);
    private _subnetId;
    get subnetId(): string;
    set subnetId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _attachment?;
    get attachment(): NetworkInterfaceAttachment[] | undefined;
    set attachment(value: NetworkInterfaceAttachment[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
