import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksApplicationConfig extends TerraformMetaArguments {
    readonly autoBundleOnDeploy?: string;
    readonly awsFlowRubySettings?: string;
    readonly dataSourceArn?: string;
    readonly dataSourceDatabaseName?: string;
    readonly dataSourceType?: string;
    readonly description?: string;
    readonly documentRoot?: string;
    readonly domains?: string[];
    readonly enableSsl?: boolean;
    readonly name: string;
    readonly railsEnv?: string;
    readonly shortName?: string;
    readonly stackId: string;
    readonly type: string;
    /** app_source block */
    readonly appSource?: OpsworksApplicationAppSource[];
    /** environment block */
    readonly environment?: OpsworksApplicationEnvironment[];
    /** ssl_configuration block */
    readonly sslConfiguration?: OpsworksApplicationSslConfiguration[];
}
export interface OpsworksApplicationAppSource {
    readonly password?: string;
    readonly revision?: string;
    readonly sshKey?: string;
    readonly type: string;
    readonly url?: string;
    readonly username?: string;
}
export interface OpsworksApplicationEnvironment {
    readonly key: string;
    readonly secure?: boolean;
    readonly value: string;
}
export interface OpsworksApplicationSslConfiguration {
    readonly certificate: string;
    readonly chain?: string;
    readonly privateKey: string;
}
export declare class OpsworksApplication extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksApplicationConfig);
    private _autoBundleOnDeploy?;
    get autoBundleOnDeploy(): string | undefined;
    set autoBundleOnDeploy(value: string | undefined);
    private _awsFlowRubySettings?;
    get awsFlowRubySettings(): string | undefined;
    set awsFlowRubySettings(value: string | undefined);
    private _dataSourceArn?;
    get dataSourceArn(): string | undefined;
    set dataSourceArn(value: string | undefined);
    private _dataSourceDatabaseName?;
    get dataSourceDatabaseName(): string | undefined;
    set dataSourceDatabaseName(value: string | undefined);
    private _dataSourceType?;
    get dataSourceType(): string | undefined;
    set dataSourceType(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _documentRoot?;
    get documentRoot(): string | undefined;
    set documentRoot(value: string | undefined);
    private _domains?;
    get domains(): string[] | undefined;
    set domains(value: string[] | undefined);
    private _enableSsl?;
    get enableSsl(): boolean | undefined;
    set enableSsl(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _railsEnv?;
    get railsEnv(): string | undefined;
    set railsEnv(value: string | undefined);
    private _shortName?;
    get shortName(): string | undefined;
    set shortName(value: string | undefined);
    private _stackId;
    get stackId(): string;
    set stackId(value: string);
    private _type;
    get type(): string;
    set type(value: string);
    private _appSource?;
    get appSource(): OpsworksApplicationAppSource[] | undefined;
    set appSource(value: OpsworksApplicationAppSource[] | undefined);
    private _environment?;
    get environment(): OpsworksApplicationEnvironment[] | undefined;
    set environment(value: OpsworksApplicationEnvironment[] | undefined);
    private _sslConfiguration?;
    get sslConfiguration(): OpsworksApplicationSslConfiguration[] | undefined;
    set sslConfiguration(value: OpsworksApplicationSslConfiguration[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
