"use strict";
// https://www.terraform.io/docs/providers/aws/r/opsworks_application.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksApplication = void 0;
const cdktf_1 = require("cdktf");
// Resource
class OpsworksApplication extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_opsworks_application',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._autoBundleOnDeploy = config.autoBundleOnDeploy;
        this._awsFlowRubySettings = config.awsFlowRubySettings;
        this._dataSourceArn = config.dataSourceArn;
        this._dataSourceDatabaseName = config.dataSourceDatabaseName;
        this._dataSourceType = config.dataSourceType;
        this._description = config.description;
        this._documentRoot = config.documentRoot;
        this._domains = config.domains;
        this._enableSsl = config.enableSsl;
        this._name = config.name;
        this._railsEnv = config.railsEnv;
        this._shortName = config.shortName;
        this._stackId = config.stackId;
        this._type = config.type;
        this._appSource = config.appSource;
        this._environment = config.environment;
        this._sslConfiguration = config.sslConfiguration;
    }
    get autoBundleOnDeploy() {
        return this._autoBundleOnDeploy;
    }
    set autoBundleOnDeploy(value) {
        this._autoBundleOnDeploy = value;
    }
    get awsFlowRubySettings() {
        return this._awsFlowRubySettings;
    }
    set awsFlowRubySettings(value) {
        this._awsFlowRubySettings = value;
    }
    get dataSourceArn() {
        return this._dataSourceArn;
    }
    set dataSourceArn(value) {
        this._dataSourceArn = value;
    }
    get dataSourceDatabaseName() {
        return this._dataSourceDatabaseName;
    }
    set dataSourceDatabaseName(value) {
        this._dataSourceDatabaseName = value;
    }
    get dataSourceType() {
        return this._dataSourceType;
    }
    set dataSourceType(value) {
        this._dataSourceType = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get documentRoot() {
        return this._documentRoot;
    }
    set documentRoot(value) {
        this._documentRoot = value;
    }
    get domains() {
        return this._domains;
    }
    set domains(value) {
        this._domains = value;
    }
    get enableSsl() {
        return this._enableSsl;
    }
    set enableSsl(value) {
        this._enableSsl = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get railsEnv() {
        return this._railsEnv;
    }
    set railsEnv(value) {
        this._railsEnv = value;
    }
    get shortName() {
        var _a;
        return (_a = this._shortName) !== null && _a !== void 0 ? _a : this.getStringAttribute('short_name');
    }
    set shortName(value) {
        this._shortName = value;
    }
    get stackId() {
        return this._stackId;
    }
    set stackId(value) {
        this._stackId = value;
    }
    get type() {
        return this._type;
    }
    set type(value) {
        this._type = value;
    }
    get appSource() {
        return this._appSource;
    }
    set appSource(value) {
        this._appSource = value;
    }
    get environment() {
        return this._environment;
    }
    set environment(value) {
        this._environment = value;
    }
    get sslConfiguration() {
        return this._sslConfiguration;
    }
    set sslConfiguration(value) {
        this._sslConfiguration = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_bundle_on_deploy: this._autoBundleOnDeploy,
            aws_flow_ruby_settings: this._awsFlowRubySettings,
            data_source_arn: this._dataSourceArn,
            data_source_database_name: this._dataSourceDatabaseName,
            data_source_type: this._dataSourceType,
            description: this._description,
            document_root: this._documentRoot,
            domains: this._domains,
            enable_ssl: this._enableSsl,
            name: this._name,
            rails_env: this._railsEnv,
            short_name: this._shortName,
            stack_id: this._stackId,
            type: this._type,
            app_source: this._appSource,
            environment: this._environment,
            ssl_configuration: this._sslConfiguration,
        };
    }
}
exports.OpsworksApplication = OpsworksApplication;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Bzd29ya3MtYXBwbGljYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvb3Bzd29ya3MtYXBwbGljYXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLDBFQUEwRTtBQUMxRSwyQ0FBMkM7OztBQXVKM0MsaUNBQTBDO0FBOEMxQyxXQUFXO0FBRVgsTUFBYSxtQkFBb0IsU0FBUSx5QkFBaUI7SUFFeEQsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjO0lBRWQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsTUFBaUM7UUFDaEYsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixxQkFBcUIsRUFBRSwwQkFBMEI7WUFDakQsMEJBQTBCLEVBQUU7Z0JBQzFCLFlBQVksRUFBRSxLQUFLO2FBQ3BCO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQUNILElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztRQUN2RCxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLHVCQUF1QixHQUFHLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQztRQUM3RCxJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsUUFBUSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUM7UUFDL0IsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxZQUFZLEdBQUcsTUFBTSxDQUFDLFdBQVcsQ0FBQztRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO0lBQ25ELENBQUM7SUFRRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsSUFBVyxrQkFBa0IsQ0FBQyxLQUF5QjtRQUNyRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQztJQUNuQyxDQUFDO0lBQ0QsSUFBVyxtQkFBbUIsQ0FBQyxLQUF5QjtRQUN0RCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsY0FBYyxDQUFDO0lBQzdCLENBQUM7SUFDRCxJQUFXLGFBQWEsQ0FBQyxLQUF5QjtRQUNoRCxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsdUJBQXVCLENBQUM7SUFDdEMsQ0FBQztJQUNELElBQVcsc0JBQXNCLENBQUMsS0FBeUI7UUFDekQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBeUI7UUFDakQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxZQUFZLENBQUM7SUFDM0IsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQXlCO1FBQzlDLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUF5QjtRQUMvQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBMkI7UUFDNUMsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQTBCO1FBQzdDLElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO0lBQzFCLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUNELElBQVcsUUFBUSxDQUFDLEtBQXlCO1FBQzNDLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLFNBQVM7O1FBQ2xCLGFBQU8sSUFBSSxDQUFDLFVBQVUsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ2xFLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUF5QjtRQUM1QyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFhO1FBQzNCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0lBQ3JCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUFpRDtRQUNwRSxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBbUQ7UUFDeEUsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQXdEO1FBQ2xGLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVMLG9CQUFvQjtRQUN6QixPQUFPO1lBQ0wscUJBQXFCLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUMvQyxzQkFBc0IsRUFBRSxJQUFJLENBQUMsb0JBQW9CO1lBQ2pELGVBQWUsRUFBRSxJQUFJLENBQUMsY0FBYztZQUNwQyx5QkFBeUIsRUFBRSxJQUFJLENBQUMsdUJBQXVCO1lBQ3ZELGdCQUFnQixFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3RDLFdBQVcsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUM5QixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsT0FBTyxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3RCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsSUFBSSxFQUFFLElBQUksQ0FBQyxLQUFLO1lBQ2hCLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQixXQUFXLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDOUIsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUMxQyxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBbk9ELGtEQW1PQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9hd3Mvci9vcHN3b3Jrc19hcHBsaWNhdGlvbi5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbi8qXG57XG4gIFwidmVyc2lvblwiOiAwLFxuICBcImJsb2NrXCI6IHtcbiAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgXCJhdXRvX2J1bmRsZV9vbl9kZXBsb3lcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJhd3NfZmxvd19ydWJ5X3NldHRpbmdzXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZGF0YV9zb3VyY2VfYXJuXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZGF0YV9zb3VyY2VfZGF0YWJhc2VfbmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImRhdGFfc291cmNlX3R5cGVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJkZXNjcmlwdGlvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImRvY3VtZW50X3Jvb3RcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJkb21haW5zXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFtcbiAgICAgICAgICBcImxpc3RcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZW5hYmxlX3NzbFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJpZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwibmFtZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInJhaWxzX2VudlwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInNob3J0X25hbWVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInN0YWNrX2lkXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidHlwZVwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH1cbiAgICB9LFxuICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgXCJhcHBfc291cmNlXCI6IHtcbiAgICAgICAgXCJuZXN0aW5nX21vZGVcIjogXCJsaXN0XCIsXG4gICAgICAgIFwiYmxvY2tcIjoge1xuICAgICAgICAgIFwiYXR0cmlidXRlc1wiOiB7XG4gICAgICAgICAgICBcInBhc3N3b3JkXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgICAgICAgXCJzZW5zaXRpdmVcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwicmV2aXNpb25cIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzc2hfa2V5XCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZSxcbiAgICAgICAgICAgICAgXCJzZW5zaXRpdmVcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidHlwZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInVybFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInVzZXJuYW1lXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfSxcbiAgICAgIFwiZW52aXJvbm1lbnRcIjoge1xuICAgICAgICBcIm5lc3RpbmdfbW9kZVwiOiBcInNldFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJrZXlcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJzZWN1cmVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwidmFsdWVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgXCJzc2xfY29uZmlndXJhdGlvblwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJjZXJ0aWZpY2F0ZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcImNoYWluXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwicHJpdmF0ZV9rZXlcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlLFxuICAgICAgICAgICAgICBcInNlbnNpdGl2ZVwiOiB0cnVlXG4gICAgICAgICAgICB9XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICB9XG59XG4qL1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBUZXJyYWZvcm1SZXNvdXJjZSB9IGZyb20gJ2Nka3RmJztcbmltcG9ydCB7IFRlcnJhZm9ybU1ldGFBcmd1bWVudHMgfSBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBPcHN3b3Jrc0FwcGxpY2F0aW9uQ29uZmlnIGV4dGVuZHMgVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIHJlYWRvbmx5IGF1dG9CdW5kbGVPbkRlcGxveT86IHN0cmluZztcbiAgcmVhZG9ubHkgYXdzRmxvd1J1YnlTZXR0aW5ncz86IHN0cmluZztcbiAgcmVhZG9ubHkgZGF0YVNvdXJjZUFybj86IHN0cmluZztcbiAgcmVhZG9ubHkgZGF0YVNvdXJjZURhdGFiYXNlTmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGF0YVNvdXJjZVR5cGU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuICByZWFkb25seSBkb2N1bWVudFJvb3Q/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRvbWFpbnM/OiBzdHJpbmdbXTtcbiAgcmVhZG9ubHkgZW5hYmxlU3NsPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICByZWFkb25seSByYWlsc0Vudj86IHN0cmluZztcbiAgcmVhZG9ubHkgc2hvcnROYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBzdGFja0lkOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgLyoqIGFwcF9zb3VyY2UgYmxvY2sgKi9cbiAgcmVhZG9ubHkgYXBwU291cmNlPzogT3Bzd29ya3NBcHBsaWNhdGlvbkFwcFNvdXJjZVtdO1xuICAvKiogZW52aXJvbm1lbnQgYmxvY2sgKi9cbiAgcmVhZG9ubHkgZW52aXJvbm1lbnQ/OiBPcHN3b3Jrc0FwcGxpY2F0aW9uRW52aXJvbm1lbnRbXTtcbiAgLyoqIHNzbF9jb25maWd1cmF0aW9uIGJsb2NrICovXG4gIHJlYWRvbmx5IHNzbENvbmZpZ3VyYXRpb24/OiBPcHN3b3Jrc0FwcGxpY2F0aW9uU3NsQ29uZmlndXJhdGlvbltdO1xufVxuZXhwb3J0IGludGVyZmFjZSBPcHN3b3Jrc0FwcGxpY2F0aW9uQXBwU291cmNlIHtcbiAgcmVhZG9ubHkgcGFzc3dvcmQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJldmlzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBzc2hLZXk/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgcmVhZG9ubHkgdXJsPzogc3RyaW5nO1xuICByZWFkb25seSB1c2VybmFtZT86IHN0cmluZztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgT3Bzd29ya3NBcHBsaWNhdGlvbkVudmlyb25tZW50IHtcbiAgcmVhZG9ubHkga2V5OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHNlY3VyZT86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHZhbHVlOiBzdHJpbmc7XG59XG5leHBvcnQgaW50ZXJmYWNlIE9wc3dvcmtzQXBwbGljYXRpb25Tc2xDb25maWd1cmF0aW9uIHtcbiAgcmVhZG9ubHkgY2VydGlmaWNhdGU6IHN0cmluZztcbiAgcmVhZG9ubHkgY2hhaW4/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHByaXZhdGVLZXk6IHN0cmluZztcbn1cblxuLy8gUmVzb3VyY2VcblxuZXhwb3J0IGNsYXNzIE9wc3dvcmtzQXBwbGljYXRpb24gZXh0ZW5kcyBUZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBPcHN3b3Jrc0FwcGxpY2F0aW9uQ29uZmlnKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6ICdhd3Nfb3Bzd29ya3NfYXBwbGljYXRpb24nLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAnYXdzJ1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlXG4gICAgfSk7XG4gICAgdGhpcy5fYXV0b0J1bmRsZU9uRGVwbG95ID0gY29uZmlnLmF1dG9CdW5kbGVPbkRlcGxveTtcbiAgICB0aGlzLl9hd3NGbG93UnVieVNldHRpbmdzID0gY29uZmlnLmF3c0Zsb3dSdWJ5U2V0dGluZ3M7XG4gICAgdGhpcy5fZGF0YVNvdXJjZUFybiA9IGNvbmZpZy5kYXRhU291cmNlQXJuO1xuICAgIHRoaXMuX2RhdGFTb3VyY2VEYXRhYmFzZU5hbWUgPSBjb25maWcuZGF0YVNvdXJjZURhdGFiYXNlTmFtZTtcbiAgICB0aGlzLl9kYXRhU291cmNlVHlwZSA9IGNvbmZpZy5kYXRhU291cmNlVHlwZTtcbiAgICB0aGlzLl9kZXNjcmlwdGlvbiA9IGNvbmZpZy5kZXNjcmlwdGlvbjtcbiAgICB0aGlzLl9kb2N1bWVudFJvb3QgPSBjb25maWcuZG9jdW1lbnRSb290O1xuICAgIHRoaXMuX2RvbWFpbnMgPSBjb25maWcuZG9tYWlucztcbiAgICB0aGlzLl9lbmFibGVTc2wgPSBjb25maWcuZW5hYmxlU3NsO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9yYWlsc0VudiA9IGNvbmZpZy5yYWlsc0VudjtcbiAgICB0aGlzLl9zaG9ydE5hbWUgPSBjb25maWcuc2hvcnROYW1lO1xuICAgIHRoaXMuX3N0YWNrSWQgPSBjb25maWcuc3RhY2tJZDtcbiAgICB0aGlzLl90eXBlID0gY29uZmlnLnR5cGU7XG4gICAgdGhpcy5fYXBwU291cmNlID0gY29uZmlnLmFwcFNvdXJjZTtcbiAgICB0aGlzLl9lbnZpcm9ubWVudCA9IGNvbmZpZy5lbnZpcm9ubWVudDtcbiAgICB0aGlzLl9zc2xDb25maWd1cmF0aW9uID0gY29uZmlnLnNzbENvbmZpZ3VyYXRpb247XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGF1dG9fYnVuZGxlX29uX2RlcGxveSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hdXRvQnVuZGxlT25EZXBsb3k/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgYXV0b0J1bmRsZU9uRGVwbG95KCkge1xuICAgIHJldHVybiB0aGlzLl9hdXRvQnVuZGxlT25EZXBsb3k7XG4gIH1cbiAgcHVibGljIHNldCBhdXRvQnVuZGxlT25EZXBsb3kodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2F1dG9CdW5kbGVPbkRlcGxveSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gYXdzX2Zsb3dfcnVieV9zZXR0aW5ncyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9hd3NGbG93UnVieVNldHRpbmdzPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGF3c0Zsb3dSdWJ5U2V0dGluZ3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F3c0Zsb3dSdWJ5U2V0dGluZ3M7XG4gIH1cbiAgcHVibGljIHNldCBhd3NGbG93UnVieVNldHRpbmdzKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hd3NGbG93UnVieVNldHRpbmdzID0gdmFsdWU7XG4gIH1cblxuICAvLyBkYXRhX3NvdXJjZV9hcm4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGF0YVNvdXJjZUFybj86IHN0cmluZztcbiAgcHVibGljIGdldCBkYXRhU291cmNlQXJuKCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRhU291cmNlQXJuO1xuICB9XG4gIHB1YmxpYyBzZXQgZGF0YVNvdXJjZUFybih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZGF0YVNvdXJjZUFybiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGF0YV9zb3VyY2VfZGF0YWJhc2VfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kYXRhU291cmNlRGF0YWJhc2VOYW1lPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGRhdGFTb3VyY2VEYXRhYmFzZU5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RhdGFTb3VyY2VEYXRhYmFzZU5hbWU7XG4gIH1cbiAgcHVibGljIHNldCBkYXRhU291cmNlRGF0YWJhc2VOYW1lKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9kYXRhU291cmNlRGF0YWJhc2VOYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyBkYXRhX3NvdXJjZV90eXBlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RhdGFTb3VyY2VUeXBlPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGRhdGFTb3VyY2VUeXBlKCkge1xuICAgIHJldHVybiB0aGlzLl9kYXRhU291cmNlVHlwZTtcbiAgfVxuICBwdWJsaWMgc2V0IGRhdGFTb3VyY2VUeXBlKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9kYXRhU291cmNlVHlwZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVzY3JpcHRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVzY3JpcHRpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZGVzY3JpcHRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Rlc2NyaXB0aW9uO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVzY3JpcHRpb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2Rlc2NyaXB0aW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBkb2N1bWVudF9yb290IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RvY3VtZW50Um9vdD86IHN0cmluZztcbiAgcHVibGljIGdldCBkb2N1bWVudFJvb3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RvY3VtZW50Um9vdDtcbiAgfVxuICBwdWJsaWMgc2V0IGRvY3VtZW50Um9vdCh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZG9jdW1lbnRSb290ID0gdmFsdWU7XG4gIH1cblxuICAvLyBkb21haW5zIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RvbWFpbnM/OiBzdHJpbmdbXTtcbiAgcHVibGljIGdldCBkb21haW5zKCkge1xuICAgIHJldHVybiB0aGlzLl9kb21haW5zO1xuICB9XG4gIHB1YmxpYyBzZXQgZG9tYWlucyh2YWx1ZTogc3RyaW5nW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9kb21haW5zID0gdmFsdWU7XG4gIH1cblxuICAvLyBlbmFibGVfc3NsIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VuYWJsZVNzbD86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgZW5hYmxlU3NsKCkge1xuICAgIHJldHVybiB0aGlzLl9lbmFibGVTc2w7XG4gIH1cbiAgcHVibGljIHNldCBlbmFibGVTc2wodmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9lbmFibGVTc2wgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cblxuICAvLyBuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX25hbWU6IHN0cmluZztcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gcmFpbHNfZW52IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JhaWxzRW52Pzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHJhaWxzRW52KCkge1xuICAgIHJldHVybiB0aGlzLl9yYWlsc0VudjtcbiAgfVxuICBwdWJsaWMgc2V0IHJhaWxzRW52KHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9yYWlsc0VudiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc2hvcnRfbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Nob3J0TmFtZT86IHN0cmluZztcbiAgcHVibGljIGdldCBzaG9ydE5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Nob3J0TmFtZSA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc2hvcnRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2hvcnROYW1lKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9zaG9ydE5hbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHN0YWNrX2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3N0YWNrSWQ6IHN0cmluZztcbiAgcHVibGljIGdldCBzdGFja0lkKCkge1xuICAgIHJldHVybiB0aGlzLl9zdGFja0lkO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RhY2tJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RhY2tJZCA9IHZhbHVlO1xuICB9XG5cbiAgLy8gdHlwZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF90eXBlOiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgdHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fdHlwZTtcbiAgfVxuICBwdWJsaWMgc2V0IHR5cGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3R5cGUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGFwcF9zb3VyY2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYXBwU291cmNlPzogT3Bzd29ya3NBcHBsaWNhdGlvbkFwcFNvdXJjZVtdO1xuICBwdWJsaWMgZ2V0IGFwcFNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXBwU291cmNlO1xuICB9XG4gIHB1YmxpYyBzZXQgYXBwU291cmNlKHZhbHVlOiBPcHN3b3Jrc0FwcGxpY2F0aW9uQXBwU291cmNlW10gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hcHBTb3VyY2UgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGVudmlyb25tZW50IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Vudmlyb25tZW50PzogT3Bzd29ya3NBcHBsaWNhdGlvbkVudmlyb25tZW50W107XG4gIHB1YmxpYyBnZXQgZW52aXJvbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Vudmlyb25tZW50O1xuICB9XG4gIHB1YmxpYyBzZXQgZW52aXJvbm1lbnQodmFsdWU6IE9wc3dvcmtzQXBwbGljYXRpb25FbnZpcm9ubWVudFtdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZW52aXJvbm1lbnQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHNzbF9jb25maWd1cmF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NzbENvbmZpZ3VyYXRpb24/OiBPcHN3b3Jrc0FwcGxpY2F0aW9uU3NsQ29uZmlndXJhdGlvbltdO1xuICBwdWJsaWMgZ2V0IHNzbENvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NzbENvbmZpZ3VyYXRpb247XG4gIH1cbiAgcHVibGljIHNldCBzc2xDb25maWd1cmF0aW9uKHZhbHVlOiBPcHN3b3Jrc0FwcGxpY2F0aW9uU3NsQ29uZmlndXJhdGlvbltdIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fc3NsQ29uZmlndXJhdGlvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhdXRvX2J1bmRsZV9vbl9kZXBsb3k6IHRoaXMuX2F1dG9CdW5kbGVPbkRlcGxveSxcbiAgICAgIGF3c19mbG93X3J1Ynlfc2V0dGluZ3M6IHRoaXMuX2F3c0Zsb3dSdWJ5U2V0dGluZ3MsXG4gICAgICBkYXRhX3NvdXJjZV9hcm46IHRoaXMuX2RhdGFTb3VyY2VBcm4sXG4gICAgICBkYXRhX3NvdXJjZV9kYXRhYmFzZV9uYW1lOiB0aGlzLl9kYXRhU291cmNlRGF0YWJhc2VOYW1lLFxuICAgICAgZGF0YV9zb3VyY2VfdHlwZTogdGhpcy5fZGF0YVNvdXJjZVR5cGUsXG4gICAgICBkZXNjcmlwdGlvbjogdGhpcy5fZGVzY3JpcHRpb24sXG4gICAgICBkb2N1bWVudF9yb290OiB0aGlzLl9kb2N1bWVudFJvb3QsXG4gICAgICBkb21haW5zOiB0aGlzLl9kb21haW5zLFxuICAgICAgZW5hYmxlX3NzbDogdGhpcy5fZW5hYmxlU3NsLFxuICAgICAgbmFtZTogdGhpcy5fbmFtZSxcbiAgICAgIHJhaWxzX2VudjogdGhpcy5fcmFpbHNFbnYsXG4gICAgICBzaG9ydF9uYW1lOiB0aGlzLl9zaG9ydE5hbWUsXG4gICAgICBzdGFja19pZDogdGhpcy5fc3RhY2tJZCxcbiAgICAgIHR5cGU6IHRoaXMuX3R5cGUsXG4gICAgICBhcHBfc291cmNlOiB0aGlzLl9hcHBTb3VyY2UsXG4gICAgICBlbnZpcm9ubWVudDogdGhpcy5fZW52aXJvbm1lbnQsXG4gICAgICBzc2xfY29uZmlndXJhdGlvbjogdGhpcy5fc3NsQ29uZmlndXJhdGlvbixcbiAgICB9O1xuICB9XG59XG4iXX0=