import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksGangliaLayerConfig extends TerraformMetaArguments {
    readonly autoAssignElasticIps?: boolean;
    readonly autoAssignPublicIps?: boolean;
    readonly autoHealing?: boolean;
    readonly customConfigureRecipes?: string[];
    readonly customDeployRecipes?: string[];
    readonly customInstanceProfileArn?: string;
    readonly customJson?: string;
    readonly customSecurityGroupIds?: string[];
    readonly customSetupRecipes?: string[];
    readonly customShutdownRecipes?: string[];
    readonly customUndeployRecipes?: string[];
    readonly drainElbOnShutdown?: boolean;
    readonly elasticLoadBalancer?: string;
    readonly installUpdatesOnBoot?: boolean;
    readonly instanceShutdownTimeout?: number;
    readonly name?: string;
    readonly password: string;
    readonly stackId: string;
    readonly systemPackages?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly url?: string;
    readonly useEbsOptimizedInstances?: boolean;
    readonly username?: string;
    /** ebs_volume block */
    readonly ebsVolume?: OpsworksGangliaLayerEbsVolume[];
}
export interface OpsworksGangliaLayerEbsVolume {
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly mountPoint: string;
    readonly numberOfDisks: number;
    readonly raidLevel?: string;
    readonly size: number;
    readonly type?: string;
}
export declare class OpsworksGangliaLayer extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksGangliaLayerConfig);
    get arn(): string;
    private _autoAssignElasticIps?;
    get autoAssignElasticIps(): boolean | undefined;
    set autoAssignElasticIps(value: boolean | undefined);
    private _autoAssignPublicIps?;
    get autoAssignPublicIps(): boolean | undefined;
    set autoAssignPublicIps(value: boolean | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | undefined;
    set autoHealing(value: boolean | undefined);
    private _customConfigureRecipes?;
    get customConfigureRecipes(): string[] | undefined;
    set customConfigureRecipes(value: string[] | undefined);
    private _customDeployRecipes?;
    get customDeployRecipes(): string[] | undefined;
    set customDeployRecipes(value: string[] | undefined);
    private _customInstanceProfileArn?;
    get customInstanceProfileArn(): string | undefined;
    set customInstanceProfileArn(value: string | undefined);
    private _customJson?;
    get customJson(): string | undefined;
    set customJson(value: string | undefined);
    private _customSecurityGroupIds?;
    get customSecurityGroupIds(): string[] | undefined;
    set customSecurityGroupIds(value: string[] | undefined);
    private _customSetupRecipes?;
    get customSetupRecipes(): string[] | undefined;
    set customSetupRecipes(value: string[] | undefined);
    private _customShutdownRecipes?;
    get customShutdownRecipes(): string[] | undefined;
    set customShutdownRecipes(value: string[] | undefined);
    private _customUndeployRecipes?;
    get customUndeployRecipes(): string[] | undefined;
    set customUndeployRecipes(value: string[] | undefined);
    private _drainElbOnShutdown?;
    get drainElbOnShutdown(): boolean | undefined;
    set drainElbOnShutdown(value: boolean | undefined);
    private _elasticLoadBalancer?;
    get elasticLoadBalancer(): string | undefined;
    set elasticLoadBalancer(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _installUpdatesOnBoot?;
    get installUpdatesOnBoot(): boolean | undefined;
    set installUpdatesOnBoot(value: boolean | undefined);
    private _instanceShutdownTimeout?;
    get instanceShutdownTimeout(): number | undefined;
    set instanceShutdownTimeout(value: number | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _password;
    get password(): string;
    set password(value: string);
    private _stackId;
    get stackId(): string;
    set stackId(value: string);
    private _systemPackages?;
    get systemPackages(): string[] | undefined;
    set systemPackages(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _url?;
    get url(): string | undefined;
    set url(value: string | undefined);
    private _useEbsOptimizedInstances?;
    get useEbsOptimizedInstances(): boolean | undefined;
    set useEbsOptimizedInstances(value: boolean | undefined);
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    private _ebsVolume?;
    get ebsVolume(): OpsworksGangliaLayerEbsVolume[] | undefined;
    set ebsVolume(value: OpsworksGangliaLayerEbsVolume[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
