import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksHaproxyLayerConfig extends TerraformMetaArguments {
    readonly autoAssignElasticIps?: boolean;
    readonly autoAssignPublicIps?: boolean;
    readonly autoHealing?: boolean;
    readonly customConfigureRecipes?: string[];
    readonly customDeployRecipes?: string[];
    readonly customInstanceProfileArn?: string;
    readonly customJson?: string;
    readonly customSecurityGroupIds?: string[];
    readonly customSetupRecipes?: string[];
    readonly customShutdownRecipes?: string[];
    readonly customUndeployRecipes?: string[];
    readonly drainElbOnShutdown?: boolean;
    readonly elasticLoadBalancer?: string;
    readonly healthcheckMethod?: string;
    readonly healthcheckUrl?: string;
    readonly installUpdatesOnBoot?: boolean;
    readonly instanceShutdownTimeout?: number;
    readonly name?: string;
    readonly stackId: string;
    readonly statsEnabled?: boolean;
    readonly statsPassword: string;
    readonly statsUrl?: string;
    readonly statsUser?: string;
    readonly systemPackages?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly useEbsOptimizedInstances?: boolean;
    /** ebs_volume block */
    readonly ebsVolume?: OpsworksHaproxyLayerEbsVolume[];
}
export interface OpsworksHaproxyLayerEbsVolume {
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly mountPoint: string;
    readonly numberOfDisks: number;
    readonly raidLevel?: string;
    readonly size: number;
    readonly type?: string;
}
export declare class OpsworksHaproxyLayer extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksHaproxyLayerConfig);
    get arn(): string;
    private _autoAssignElasticIps?;
    get autoAssignElasticIps(): boolean | undefined;
    set autoAssignElasticIps(value: boolean | undefined);
    private _autoAssignPublicIps?;
    get autoAssignPublicIps(): boolean | undefined;
    set autoAssignPublicIps(value: boolean | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | undefined;
    set autoHealing(value: boolean | undefined);
    private _customConfigureRecipes?;
    get customConfigureRecipes(): string[] | undefined;
    set customConfigureRecipes(value: string[] | undefined);
    private _customDeployRecipes?;
    get customDeployRecipes(): string[] | undefined;
    set customDeployRecipes(value: string[] | undefined);
    private _customInstanceProfileArn?;
    get customInstanceProfileArn(): string | undefined;
    set customInstanceProfileArn(value: string | undefined);
    private _customJson?;
    get customJson(): string | undefined;
    set customJson(value: string | undefined);
    private _customSecurityGroupIds?;
    get customSecurityGroupIds(): string[] | undefined;
    set customSecurityGroupIds(value: string[] | undefined);
    private _customSetupRecipes?;
    get customSetupRecipes(): string[] | undefined;
    set customSetupRecipes(value: string[] | undefined);
    private _customShutdownRecipes?;
    get customShutdownRecipes(): string[] | undefined;
    set customShutdownRecipes(value: string[] | undefined);
    private _customUndeployRecipes?;
    get customUndeployRecipes(): string[] | undefined;
    set customUndeployRecipes(value: string[] | undefined);
    private _drainElbOnShutdown?;
    get drainElbOnShutdown(): boolean | undefined;
    set drainElbOnShutdown(value: boolean | undefined);
    private _elasticLoadBalancer?;
    get elasticLoadBalancer(): string | undefined;
    set elasticLoadBalancer(value: string | undefined);
    private _healthcheckMethod?;
    get healthcheckMethod(): string | undefined;
    set healthcheckMethod(value: string | undefined);
    private _healthcheckUrl?;
    get healthcheckUrl(): string | undefined;
    set healthcheckUrl(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _installUpdatesOnBoot?;
    get installUpdatesOnBoot(): boolean | undefined;
    set installUpdatesOnBoot(value: boolean | undefined);
    private _instanceShutdownTimeout?;
    get instanceShutdownTimeout(): number | undefined;
    set instanceShutdownTimeout(value: number | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _stackId;
    get stackId(): string;
    set stackId(value: string);
    private _statsEnabled?;
    get statsEnabled(): boolean | undefined;
    set statsEnabled(value: boolean | undefined);
    private _statsPassword;
    get statsPassword(): string;
    set statsPassword(value: string);
    private _statsUrl?;
    get statsUrl(): string | undefined;
    set statsUrl(value: string | undefined);
    private _statsUser?;
    get statsUser(): string | undefined;
    set statsUser(value: string | undefined);
    private _systemPackages?;
    get systemPackages(): string[] | undefined;
    set systemPackages(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _useEbsOptimizedInstances?;
    get useEbsOptimizedInstances(): boolean | undefined;
    set useEbsOptimizedInstances(value: boolean | undefined);
    private _ebsVolume?;
    get ebsVolume(): OpsworksHaproxyLayerEbsVolume[] | undefined;
    set ebsVolume(value: OpsworksHaproxyLayerEbsVolume[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
