"use strict";
// https://www.terraform.io/docs/providers/aws/r/opsworks_haproxy_layer.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksHaproxyLayer = void 0;
const cdktf_1 = require("cdktf");
// Resource
class OpsworksHaproxyLayer extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_opsworks_haproxy_layer',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._autoAssignElasticIps = config.autoAssignElasticIps;
        this._autoAssignPublicIps = config.autoAssignPublicIps;
        this._autoHealing = config.autoHealing;
        this._customConfigureRecipes = config.customConfigureRecipes;
        this._customDeployRecipes = config.customDeployRecipes;
        this._customInstanceProfileArn = config.customInstanceProfileArn;
        this._customJson = config.customJson;
        this._customSecurityGroupIds = config.customSecurityGroupIds;
        this._customSetupRecipes = config.customSetupRecipes;
        this._customShutdownRecipes = config.customShutdownRecipes;
        this._customUndeployRecipes = config.customUndeployRecipes;
        this._drainElbOnShutdown = config.drainElbOnShutdown;
        this._elasticLoadBalancer = config.elasticLoadBalancer;
        this._healthcheckMethod = config.healthcheckMethod;
        this._healthcheckUrl = config.healthcheckUrl;
        this._installUpdatesOnBoot = config.installUpdatesOnBoot;
        this._instanceShutdownTimeout = config.instanceShutdownTimeout;
        this._name = config.name;
        this._stackId = config.stackId;
        this._statsEnabled = config.statsEnabled;
        this._statsPassword = config.statsPassword;
        this._statsUrl = config.statsUrl;
        this._statsUser = config.statsUser;
        this._systemPackages = config.systemPackages;
        this._tags = config.tags;
        this._useEbsOptimizedInstances = config.useEbsOptimizedInstances;
        this._ebsVolume = config.ebsVolume;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoAssignElasticIps() {
        return this._autoAssignElasticIps;
    }
    set autoAssignElasticIps(value) {
        this._autoAssignElasticIps = value;
    }
    get autoAssignPublicIps() {
        return this._autoAssignPublicIps;
    }
    set autoAssignPublicIps(value) {
        this._autoAssignPublicIps = value;
    }
    get autoHealing() {
        return this._autoHealing;
    }
    set autoHealing(value) {
        this._autoHealing = value;
    }
    get customConfigureRecipes() {
        return this._customConfigureRecipes;
    }
    set customConfigureRecipes(value) {
        this._customConfigureRecipes = value;
    }
    get customDeployRecipes() {
        return this._customDeployRecipes;
    }
    set customDeployRecipes(value) {
        this._customDeployRecipes = value;
    }
    get customInstanceProfileArn() {
        return this._customInstanceProfileArn;
    }
    set customInstanceProfileArn(value) {
        this._customInstanceProfileArn = value;
    }
    get customJson() {
        return this._customJson;
    }
    set customJson(value) {
        this._customJson = value;
    }
    get customSecurityGroupIds() {
        return this._customSecurityGroupIds;
    }
    set customSecurityGroupIds(value) {
        this._customSecurityGroupIds = value;
    }
    get customSetupRecipes() {
        return this._customSetupRecipes;
    }
    set customSetupRecipes(value) {
        this._customSetupRecipes = value;
    }
    get customShutdownRecipes() {
        return this._customShutdownRecipes;
    }
    set customShutdownRecipes(value) {
        this._customShutdownRecipes = value;
    }
    get customUndeployRecipes() {
        return this._customUndeployRecipes;
    }
    set customUndeployRecipes(value) {
        this._customUndeployRecipes = value;
    }
    get drainElbOnShutdown() {
        return this._drainElbOnShutdown;
    }
    set drainElbOnShutdown(value) {
        this._drainElbOnShutdown = value;
    }
    get elasticLoadBalancer() {
        return this._elasticLoadBalancer;
    }
    set elasticLoadBalancer(value) {
        this._elasticLoadBalancer = value;
    }
    get healthcheckMethod() {
        return this._healthcheckMethod;
    }
    set healthcheckMethod(value) {
        this._healthcheckMethod = value;
    }
    get healthcheckUrl() {
        return this._healthcheckUrl;
    }
    set healthcheckUrl(value) {
        this._healthcheckUrl = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get installUpdatesOnBoot() {
        return this._installUpdatesOnBoot;
    }
    set installUpdatesOnBoot(value) {
        this._installUpdatesOnBoot = value;
    }
    get instanceShutdownTimeout() {
        return this._instanceShutdownTimeout;
    }
    set instanceShutdownTimeout(value) {
        this._instanceShutdownTimeout = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get stackId() {
        return this._stackId;
    }
    set stackId(value) {
        this._stackId = value;
    }
    get statsEnabled() {
        return this._statsEnabled;
    }
    set statsEnabled(value) {
        this._statsEnabled = value;
    }
    get statsPassword() {
        return this._statsPassword;
    }
    set statsPassword(value) {
        this._statsPassword = value;
    }
    get statsUrl() {
        return this._statsUrl;
    }
    set statsUrl(value) {
        this._statsUrl = value;
    }
    get statsUser() {
        return this._statsUser;
    }
    set statsUser(value) {
        this._statsUser = value;
    }
    get systemPackages() {
        return this._systemPackages;
    }
    set systemPackages(value) {
        this._systemPackages = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get useEbsOptimizedInstances() {
        return this._useEbsOptimizedInstances;
    }
    set useEbsOptimizedInstances(value) {
        this._useEbsOptimizedInstances = value;
    }
    get ebsVolume() {
        return this._ebsVolume;
    }
    set ebsVolume(value) {
        this._ebsVolume = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_assign_elastic_ips: this._autoAssignElasticIps,
            auto_assign_public_ips: this._autoAssignPublicIps,
            auto_healing: this._autoHealing,
            custom_configure_recipes: this._customConfigureRecipes,
            custom_deploy_recipes: this._customDeployRecipes,
            custom_instance_profile_arn: this._customInstanceProfileArn,
            custom_json: this._customJson,
            custom_security_group_ids: this._customSecurityGroupIds,
            custom_setup_recipes: this._customSetupRecipes,
            custom_shutdown_recipes: this._customShutdownRecipes,
            custom_undeploy_recipes: this._customUndeployRecipes,
            drain_elb_on_shutdown: this._drainElbOnShutdown,
            elastic_load_balancer: this._elasticLoadBalancer,
            healthcheck_method: this._healthcheckMethod,
            healthcheck_url: this._healthcheckUrl,
            install_updates_on_boot: this._installUpdatesOnBoot,
            instance_shutdown_timeout: this._instanceShutdownTimeout,
            name: this._name,
            stack_id: this._stackId,
            stats_enabled: this._statsEnabled,
            stats_password: this._statsPassword,
            stats_url: this._statsUrl,
            stats_user: this._statsUser,
            system_packages: this._systemPackages,
            tags: this._tags,
            use_ebs_optimized_instances: this._useEbsOptimizedInstances,
            ebs_volume: this._ebsVolume,
        };
    }
}
exports.OpsworksHaproxyLayer = OpsworksHaproxyLayer;
//# sourceMappingURL=data:application/json;base64,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