import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksInstanceConfig extends TerraformMetaArguments {
    readonly agentVersion?: string;
    readonly amiId?: string;
    readonly architecture?: string;
    readonly autoScalingType?: string;
    readonly availabilityZone?: string;
    readonly createdAt?: string;
    readonly deleteEbs?: boolean;
    readonly deleteEip?: boolean;
    readonly ebsOptimized?: boolean;
    readonly ecsClusterArn?: string;
    readonly elasticIp?: string;
    readonly hostname?: string;
    readonly infrastructureClass?: string;
    readonly installUpdatesOnBoot?: boolean;
    readonly instanceProfileArn?: string;
    readonly instanceType?: string;
    readonly lastServiceErrorId?: string;
    readonly layerIds: string[];
    readonly os?: string;
    readonly platform?: string;
    readonly privateDns?: string;
    readonly privateIp?: string;
    readonly publicDns?: string;
    readonly publicIp?: string;
    readonly registeredBy?: string;
    readonly reportedAgentVersion?: string;
    readonly reportedOsFamily?: string;
    readonly reportedOsName?: string;
    readonly reportedOsVersion?: string;
    readonly rootDeviceType?: string;
    readonly rootDeviceVolumeId?: string;
    readonly securityGroupIds?: string[];
    readonly sshHostDsaKeyFingerprint?: string;
    readonly sshHostRsaKeyFingerprint?: string;
    readonly sshKeyName?: string;
    readonly stackId: string;
    readonly state?: string;
    readonly status?: string;
    readonly subnetId?: string;
    readonly tenancy?: string;
    readonly virtualizationType?: string;
    /** ebs_block_device block */
    readonly ebsBlockDevice?: OpsworksInstanceEbsBlockDevice[];
    /** ephemeral_block_device block */
    readonly ephemeralBlockDevice?: OpsworksInstanceEphemeralBlockDevice[];
    /** root_block_device block */
    readonly rootBlockDevice?: OpsworksInstanceRootBlockDevice[];
    /** timeouts block */
    readonly timeouts?: OpsworksInstanceTimeouts;
}
export interface OpsworksInstanceEbsBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly deviceName: string;
    readonly iops?: number;
    readonly snapshotId?: string;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface OpsworksInstanceEphemeralBlockDevice {
    readonly deviceName: string;
    readonly virtualName: string;
}
export interface OpsworksInstanceRootBlockDevice {
    readonly deleteOnTermination?: boolean;
    readonly iops?: number;
    readonly volumeSize?: number;
    readonly volumeType?: string;
}
export interface OpsworksInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class OpsworksInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksInstanceConfig);
    private _agentVersion?;
    get agentVersion(): string | undefined;
    set agentVersion(value: string | undefined);
    private _amiId?;
    get amiId(): string | undefined;
    set amiId(value: string | undefined);
    private _architecture?;
    get architecture(): string | undefined;
    set architecture(value: string | undefined);
    private _autoScalingType?;
    get autoScalingType(): string | undefined;
    set autoScalingType(value: string | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _createdAt?;
    get createdAt(): string | undefined;
    set createdAt(value: string | undefined);
    private _deleteEbs?;
    get deleteEbs(): boolean | undefined;
    set deleteEbs(value: boolean | undefined);
    private _deleteEip?;
    get deleteEip(): boolean | undefined;
    set deleteEip(value: boolean | undefined);
    private _ebsOptimized?;
    get ebsOptimized(): boolean | undefined;
    set ebsOptimized(value: boolean | undefined);
    get ec2InstanceId(): string;
    private _ecsClusterArn?;
    get ecsClusterArn(): string | undefined;
    set ecsClusterArn(value: string | undefined);
    private _elasticIp?;
    get elasticIp(): string | undefined;
    set elasticIp(value: string | undefined);
    private _hostname?;
    get hostname(): string | undefined;
    set hostname(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _infrastructureClass?;
    get infrastructureClass(): string | undefined;
    set infrastructureClass(value: string | undefined);
    private _installUpdatesOnBoot?;
    get installUpdatesOnBoot(): boolean | undefined;
    set installUpdatesOnBoot(value: boolean | undefined);
    private _instanceProfileArn?;
    get instanceProfileArn(): string | undefined;
    set instanceProfileArn(value: string | undefined);
    private _instanceType?;
    get instanceType(): string | undefined;
    set instanceType(value: string | undefined);
    private _lastServiceErrorId?;
    get lastServiceErrorId(): string | undefined;
    set lastServiceErrorId(value: string | undefined);
    private _layerIds;
    get layerIds(): string[];
    set layerIds(value: string[]);
    private _os?;
    get os(): string | undefined;
    set os(value: string | undefined);
    private _platform?;
    get platform(): string | undefined;
    set platform(value: string | undefined);
    private _privateDns?;
    get privateDns(): string | undefined;
    set privateDns(value: string | undefined);
    private _privateIp?;
    get privateIp(): string | undefined;
    set privateIp(value: string | undefined);
    private _publicDns?;
    get publicDns(): string | undefined;
    set publicDns(value: string | undefined);
    private _publicIp?;
    get publicIp(): string | undefined;
    set publicIp(value: string | undefined);
    private _registeredBy?;
    get registeredBy(): string | undefined;
    set registeredBy(value: string | undefined);
    private _reportedAgentVersion?;
    get reportedAgentVersion(): string | undefined;
    set reportedAgentVersion(value: string | undefined);
    private _reportedOsFamily?;
    get reportedOsFamily(): string | undefined;
    set reportedOsFamily(value: string | undefined);
    private _reportedOsName?;
    get reportedOsName(): string | undefined;
    set reportedOsName(value: string | undefined);
    private _reportedOsVersion?;
    get reportedOsVersion(): string | undefined;
    set reportedOsVersion(value: string | undefined);
    private _rootDeviceType?;
    get rootDeviceType(): string | undefined;
    set rootDeviceType(value: string | undefined);
    private _rootDeviceVolumeId?;
    get rootDeviceVolumeId(): string | undefined;
    set rootDeviceVolumeId(value: string | undefined);
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _sshHostDsaKeyFingerprint?;
    get sshHostDsaKeyFingerprint(): string | undefined;
    set sshHostDsaKeyFingerprint(value: string | undefined);
    private _sshHostRsaKeyFingerprint?;
    get sshHostRsaKeyFingerprint(): string | undefined;
    set sshHostRsaKeyFingerprint(value: string | undefined);
    private _sshKeyName?;
    get sshKeyName(): string | undefined;
    set sshKeyName(value: string | undefined);
    private _stackId;
    get stackId(): string;
    set stackId(value: string);
    private _state?;
    get state(): string | undefined;
    set state(value: string | undefined);
    private _status?;
    get status(): string | undefined;
    set status(value: string | undefined);
    private _subnetId?;
    get subnetId(): string | undefined;
    set subnetId(value: string | undefined);
    private _tenancy?;
    get tenancy(): string | undefined;
    set tenancy(value: string | undefined);
    private _virtualizationType?;
    get virtualizationType(): string | undefined;
    set virtualizationType(value: string | undefined);
    private _ebsBlockDevice?;
    get ebsBlockDevice(): OpsworksInstanceEbsBlockDevice[] | undefined;
    set ebsBlockDevice(value: OpsworksInstanceEbsBlockDevice[] | undefined);
    private _ephemeralBlockDevice?;
    get ephemeralBlockDevice(): OpsworksInstanceEphemeralBlockDevice[] | undefined;
    set ephemeralBlockDevice(value: OpsworksInstanceEphemeralBlockDevice[] | undefined);
    private _rootBlockDevice?;
    get rootBlockDevice(): OpsworksInstanceRootBlockDevice[] | undefined;
    set rootBlockDevice(value: OpsworksInstanceRootBlockDevice[] | undefined);
    private _timeouts?;
    get timeouts(): OpsworksInstanceTimeouts | undefined;
    set timeouts(value: OpsworksInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
