"use strict";
// https://www.terraform.io/docs/providers/aws/r/opsworks_instance.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksInstance = void 0;
const cdktf_1 = require("cdktf");
// Resource
class OpsworksInstance extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_opsworks_instance',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._agentVersion = config.agentVersion;
        this._amiId = config.amiId;
        this._architecture = config.architecture;
        this._autoScalingType = config.autoScalingType;
        this._availabilityZone = config.availabilityZone;
        this._createdAt = config.createdAt;
        this._deleteEbs = config.deleteEbs;
        this._deleteEip = config.deleteEip;
        this._ebsOptimized = config.ebsOptimized;
        this._ecsClusterArn = config.ecsClusterArn;
        this._elasticIp = config.elasticIp;
        this._hostname = config.hostname;
        this._infrastructureClass = config.infrastructureClass;
        this._installUpdatesOnBoot = config.installUpdatesOnBoot;
        this._instanceProfileArn = config.instanceProfileArn;
        this._instanceType = config.instanceType;
        this._lastServiceErrorId = config.lastServiceErrorId;
        this._layerIds = config.layerIds;
        this._os = config.os;
        this._platform = config.platform;
        this._privateDns = config.privateDns;
        this._privateIp = config.privateIp;
        this._publicDns = config.publicDns;
        this._publicIp = config.publicIp;
        this._registeredBy = config.registeredBy;
        this._reportedAgentVersion = config.reportedAgentVersion;
        this._reportedOsFamily = config.reportedOsFamily;
        this._reportedOsName = config.reportedOsName;
        this._reportedOsVersion = config.reportedOsVersion;
        this._rootDeviceType = config.rootDeviceType;
        this._rootDeviceVolumeId = config.rootDeviceVolumeId;
        this._securityGroupIds = config.securityGroupIds;
        this._sshHostDsaKeyFingerprint = config.sshHostDsaKeyFingerprint;
        this._sshHostRsaKeyFingerprint = config.sshHostRsaKeyFingerprint;
        this._sshKeyName = config.sshKeyName;
        this._stackId = config.stackId;
        this._state = config.state;
        this._status = config.status;
        this._subnetId = config.subnetId;
        this._tenancy = config.tenancy;
        this._virtualizationType = config.virtualizationType;
        this._ebsBlockDevice = config.ebsBlockDevice;
        this._ephemeralBlockDevice = config.ephemeralBlockDevice;
        this._rootBlockDevice = config.rootBlockDevice;
        this._timeouts = config.timeouts;
    }
    get agentVersion() {
        return this._agentVersion;
    }
    set agentVersion(value) {
        this._agentVersion = value;
    }
    get amiId() {
        var _a;
        return (_a = this._amiId) !== null && _a !== void 0 ? _a : this.getStringAttribute('ami_id');
    }
    set amiId(value) {
        this._amiId = value;
    }
    get architecture() {
        return this._architecture;
    }
    set architecture(value) {
        this._architecture = value;
    }
    get autoScalingType() {
        return this._autoScalingType;
    }
    set autoScalingType(value) {
        this._autoScalingType = value;
    }
    get availabilityZone() {
        var _a;
        return (_a = this._availabilityZone) !== null && _a !== void 0 ? _a : this.getStringAttribute('availability_zone');
    }
    set availabilityZone(value) {
        this._availabilityZone = value;
    }
    get createdAt() {
        var _a;
        return (_a = this._createdAt) !== null && _a !== void 0 ? _a : this.getStringAttribute('created_at');
    }
    set createdAt(value) {
        this._createdAt = value;
    }
    get deleteEbs() {
        return this._deleteEbs;
    }
    set deleteEbs(value) {
        this._deleteEbs = value;
    }
    get deleteEip() {
        return this._deleteEip;
    }
    set deleteEip(value) {
        this._deleteEip = value;
    }
    get ebsOptimized() {
        return this._ebsOptimized;
    }
    set ebsOptimized(value) {
        this._ebsOptimized = value;
    }
    // ec2_instance_id - computed: true, optional: false, required: true
    get ec2InstanceId() {
        return this.getStringAttribute('ec2_instance_id');
    }
    get ecsClusterArn() {
        var _a;
        return (_a = this._ecsClusterArn) !== null && _a !== void 0 ? _a : this.getStringAttribute('ecs_cluster_arn');
    }
    set ecsClusterArn(value) {
        this._ecsClusterArn = value;
    }
    get elasticIp() {
        var _a;
        return (_a = this._elasticIp) !== null && _a !== void 0 ? _a : this.getStringAttribute('elastic_ip');
    }
    set elasticIp(value) {
        this._elasticIp = value;
    }
    get hostname() {
        var _a;
        return (_a = this._hostname) !== null && _a !== void 0 ? _a : this.getStringAttribute('hostname');
    }
    set hostname(value) {
        this._hostname = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get infrastructureClass() {
        var _a;
        return (_a = this._infrastructureClass) !== null && _a !== void 0 ? _a : this.getStringAttribute('infrastructure_class');
    }
    set infrastructureClass(value) {
        this._infrastructureClass = value;
    }
    get installUpdatesOnBoot() {
        return this._installUpdatesOnBoot;
    }
    set installUpdatesOnBoot(value) {
        this._installUpdatesOnBoot = value;
    }
    get instanceProfileArn() {
        var _a;
        return (_a = this._instanceProfileArn) !== null && _a !== void 0 ? _a : this.getStringAttribute('instance_profile_arn');
    }
    set instanceProfileArn(value) {
        this._instanceProfileArn = value;
    }
    get instanceType() {
        return this._instanceType;
    }
    set instanceType(value) {
        this._instanceType = value;
    }
    get lastServiceErrorId() {
        var _a;
        return (_a = this._lastServiceErrorId) !== null && _a !== void 0 ? _a : this.getStringAttribute('last_service_error_id');
    }
    set lastServiceErrorId(value) {
        this._lastServiceErrorId = value;
    }
    get layerIds() {
        return this._layerIds;
    }
    set layerIds(value) {
        this._layerIds = value;
    }
    get os() {
        var _a;
        return (_a = this._os) !== null && _a !== void 0 ? _a : this.getStringAttribute('os');
    }
    set os(value) {
        this._os = value;
    }
    get platform() {
        var _a;
        return (_a = this._platform) !== null && _a !== void 0 ? _a : this.getStringAttribute('platform');
    }
    set platform(value) {
        this._platform = value;
    }
    get privateDns() {
        var _a;
        return (_a = this._privateDns) !== null && _a !== void 0 ? _a : this.getStringAttribute('private_dns');
    }
    set privateDns(value) {
        this._privateDns = value;
    }
    get privateIp() {
        var _a;
        return (_a = this._privateIp) !== null && _a !== void 0 ? _a : this.getStringAttribute('private_ip');
    }
    set privateIp(value) {
        this._privateIp = value;
    }
    get publicDns() {
        var _a;
        return (_a = this._publicDns) !== null && _a !== void 0 ? _a : this.getStringAttribute('public_dns');
    }
    set publicDns(value) {
        this._publicDns = value;
    }
    get publicIp() {
        var _a;
        return (_a = this._publicIp) !== null && _a !== void 0 ? _a : this.getStringAttribute('public_ip');
    }
    set publicIp(value) {
        this._publicIp = value;
    }
    get registeredBy() {
        var _a;
        return (_a = this._registeredBy) !== null && _a !== void 0 ? _a : this.getStringAttribute('registered_by');
    }
    set registeredBy(value) {
        this._registeredBy = value;
    }
    get reportedAgentVersion() {
        var _a;
        return (_a = this._reportedAgentVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('reported_agent_version');
    }
    set reportedAgentVersion(value) {
        this._reportedAgentVersion = value;
    }
    get reportedOsFamily() {
        var _a;
        return (_a = this._reportedOsFamily) !== null && _a !== void 0 ? _a : this.getStringAttribute('reported_os_family');
    }
    set reportedOsFamily(value) {
        this._reportedOsFamily = value;
    }
    get reportedOsName() {
        var _a;
        return (_a = this._reportedOsName) !== null && _a !== void 0 ? _a : this.getStringAttribute('reported_os_name');
    }
    set reportedOsName(value) {
        this._reportedOsName = value;
    }
    get reportedOsVersion() {
        var _a;
        return (_a = this._reportedOsVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('reported_os_version');
    }
    set reportedOsVersion(value) {
        this._reportedOsVersion = value;
    }
    get rootDeviceType() {
        var _a;
        return (_a = this._rootDeviceType) !== null && _a !== void 0 ? _a : this.getStringAttribute('root_device_type');
    }
    set rootDeviceType(value) {
        this._rootDeviceType = value;
    }
    get rootDeviceVolumeId() {
        var _a;
        return (_a = this._rootDeviceVolumeId) !== null && _a !== void 0 ? _a : this.getStringAttribute('root_device_volume_id');
    }
    set rootDeviceVolumeId(value) {
        this._rootDeviceVolumeId = value;
    }
    get securityGroupIds() {
        var _a;
        return (_a = this._securityGroupIds) !== null && _a !== void 0 ? _a : this.getListAttribute('security_group_ids');
    }
    set securityGroupIds(value) {
        this._securityGroupIds = value;
    }
    get sshHostDsaKeyFingerprint() {
        var _a;
        return (_a = this._sshHostDsaKeyFingerprint) !== null && _a !== void 0 ? _a : this.getStringAttribute('ssh_host_dsa_key_fingerprint');
    }
    set sshHostDsaKeyFingerprint(value) {
        this._sshHostDsaKeyFingerprint = value;
    }
    get sshHostRsaKeyFingerprint() {
        var _a;
        return (_a = this._sshHostRsaKeyFingerprint) !== null && _a !== void 0 ? _a : this.getStringAttribute('ssh_host_rsa_key_fingerprint');
    }
    set sshHostRsaKeyFingerprint(value) {
        this._sshHostRsaKeyFingerprint = value;
    }
    get sshKeyName() {
        var _a;
        return (_a = this._sshKeyName) !== null && _a !== void 0 ? _a : this.getStringAttribute('ssh_key_name');
    }
    set sshKeyName(value) {
        this._sshKeyName = value;
    }
    get stackId() {
        return this._stackId;
    }
    set stackId(value) {
        this._stackId = value;
    }
    get state() {
        return this._state;
    }
    set state(value) {
        this._state = value;
    }
    get status() {
        var _a;
        return (_a = this._status) !== null && _a !== void 0 ? _a : this.getStringAttribute('status');
    }
    set status(value) {
        this._status = value;
    }
    get subnetId() {
        var _a;
        return (_a = this._subnetId) !== null && _a !== void 0 ? _a : this.getStringAttribute('subnet_id');
    }
    set subnetId(value) {
        this._subnetId = value;
    }
    get tenancy() {
        var _a;
        return (_a = this._tenancy) !== null && _a !== void 0 ? _a : this.getStringAttribute('tenancy');
    }
    set tenancy(value) {
        this._tenancy = value;
    }
    get virtualizationType() {
        var _a;
        return (_a = this._virtualizationType) !== null && _a !== void 0 ? _a : this.getStringAttribute('virtualization_type');
    }
    set virtualizationType(value) {
        this._virtualizationType = value;
    }
    get ebsBlockDevice() {
        return this._ebsBlockDevice;
    }
    set ebsBlockDevice(value) {
        this._ebsBlockDevice = value;
    }
    get ephemeralBlockDevice() {
        return this._ephemeralBlockDevice;
    }
    set ephemeralBlockDevice(value) {
        this._ephemeralBlockDevice = value;
    }
    get rootBlockDevice() {
        return this._rootBlockDevice;
    }
    set rootBlockDevice(value) {
        this._rootBlockDevice = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            agent_version: this._agentVersion,
            ami_id: this._amiId,
            architecture: this._architecture,
            auto_scaling_type: this._autoScalingType,
            availability_zone: this._availabilityZone,
            created_at: this._createdAt,
            delete_ebs: this._deleteEbs,
            delete_eip: this._deleteEip,
            ebs_optimized: this._ebsOptimized,
            ecs_cluster_arn: this._ecsClusterArn,
            elastic_ip: this._elasticIp,
            hostname: this._hostname,
            infrastructure_class: this._infrastructureClass,
            install_updates_on_boot: this._installUpdatesOnBoot,
            instance_profile_arn: this._instanceProfileArn,
            instance_type: this._instanceType,
            last_service_error_id: this._lastServiceErrorId,
            layer_ids: this._layerIds,
            os: this._os,
            platform: this._platform,
            private_dns: this._privateDns,
            private_ip: this._privateIp,
            public_dns: this._publicDns,
            public_ip: this._publicIp,
            registered_by: this._registeredBy,
            reported_agent_version: this._reportedAgentVersion,
            reported_os_family: this._reportedOsFamily,
            reported_os_name: this._reportedOsName,
            reported_os_version: this._reportedOsVersion,
            root_device_type: this._rootDeviceType,
            root_device_volume_id: this._rootDeviceVolumeId,
            security_group_ids: this._securityGroupIds,
            ssh_host_dsa_key_fingerprint: this._sshHostDsaKeyFingerprint,
            ssh_host_rsa_key_fingerprint: this._sshHostRsaKeyFingerprint,
            ssh_key_name: this._sshKeyName,
            stack_id: this._stackId,
            state: this._state,
            status: this._status,
            subnet_id: this._subnetId,
            tenancy: this._tenancy,
            virtualization_type: this._virtualizationType,
            ebs_block_device: this._ebsBlockDevice,
            ephemeral_block_device: this._ephemeralBlockDevice,
            root_block_device: this._rootBlockDevice,
            timeouts: this._timeouts,
        };
    }
}
exports.OpsworksInstance = OpsworksInstance;
//# sourceMappingURL=data:application/json;base64,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