import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksJavaAppLayerConfig extends TerraformMetaArguments {
    readonly appServer?: string;
    readonly appServerVersion?: string;
    readonly autoAssignElasticIps?: boolean;
    readonly autoAssignPublicIps?: boolean;
    readonly autoHealing?: boolean;
    readonly customConfigureRecipes?: string[];
    readonly customDeployRecipes?: string[];
    readonly customInstanceProfileArn?: string;
    readonly customJson?: string;
    readonly customSecurityGroupIds?: string[];
    readonly customSetupRecipes?: string[];
    readonly customShutdownRecipes?: string[];
    readonly customUndeployRecipes?: string[];
    readonly drainElbOnShutdown?: boolean;
    readonly elasticLoadBalancer?: string;
    readonly installUpdatesOnBoot?: boolean;
    readonly instanceShutdownTimeout?: number;
    readonly jvmOptions?: string;
    readonly jvmType?: string;
    readonly jvmVersion?: string;
    readonly name?: string;
    readonly stackId: string;
    readonly systemPackages?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly useEbsOptimizedInstances?: boolean;
    /** ebs_volume block */
    readonly ebsVolume?: OpsworksJavaAppLayerEbsVolume[];
}
export interface OpsworksJavaAppLayerEbsVolume {
    readonly encrypted?: boolean;
    readonly iops?: number;
    readonly mountPoint: string;
    readonly numberOfDisks: number;
    readonly raidLevel?: string;
    readonly size: number;
    readonly type?: string;
}
export declare class OpsworksJavaAppLayer extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksJavaAppLayerConfig);
    private _appServer?;
    get appServer(): string | undefined;
    set appServer(value: string | undefined);
    private _appServerVersion?;
    get appServerVersion(): string | undefined;
    set appServerVersion(value: string | undefined);
    get arn(): string;
    private _autoAssignElasticIps?;
    get autoAssignElasticIps(): boolean | undefined;
    set autoAssignElasticIps(value: boolean | undefined);
    private _autoAssignPublicIps?;
    get autoAssignPublicIps(): boolean | undefined;
    set autoAssignPublicIps(value: boolean | undefined);
    private _autoHealing?;
    get autoHealing(): boolean | undefined;
    set autoHealing(value: boolean | undefined);
    private _customConfigureRecipes?;
    get customConfigureRecipes(): string[] | undefined;
    set customConfigureRecipes(value: string[] | undefined);
    private _customDeployRecipes?;
    get customDeployRecipes(): string[] | undefined;
    set customDeployRecipes(value: string[] | undefined);
    private _customInstanceProfileArn?;
    get customInstanceProfileArn(): string | undefined;
    set customInstanceProfileArn(value: string | undefined);
    private _customJson?;
    get customJson(): string | undefined;
    set customJson(value: string | undefined);
    private _customSecurityGroupIds?;
    get customSecurityGroupIds(): string[] | undefined;
    set customSecurityGroupIds(value: string[] | undefined);
    private _customSetupRecipes?;
    get customSetupRecipes(): string[] | undefined;
    set customSetupRecipes(value: string[] | undefined);
    private _customShutdownRecipes?;
    get customShutdownRecipes(): string[] | undefined;
    set customShutdownRecipes(value: string[] | undefined);
    private _customUndeployRecipes?;
    get customUndeployRecipes(): string[] | undefined;
    set customUndeployRecipes(value: string[] | undefined);
    private _drainElbOnShutdown?;
    get drainElbOnShutdown(): boolean | undefined;
    set drainElbOnShutdown(value: boolean | undefined);
    private _elasticLoadBalancer?;
    get elasticLoadBalancer(): string | undefined;
    set elasticLoadBalancer(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _installUpdatesOnBoot?;
    get installUpdatesOnBoot(): boolean | undefined;
    set installUpdatesOnBoot(value: boolean | undefined);
    private _instanceShutdownTimeout?;
    get instanceShutdownTimeout(): number | undefined;
    set instanceShutdownTimeout(value: number | undefined);
    private _jvmOptions?;
    get jvmOptions(): string | undefined;
    set jvmOptions(value: string | undefined);
    private _jvmType?;
    get jvmType(): string | undefined;
    set jvmType(value: string | undefined);
    private _jvmVersion?;
    get jvmVersion(): string | undefined;
    set jvmVersion(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _stackId;
    get stackId(): string;
    set stackId(value: string);
    private _systemPackages?;
    get systemPackages(): string[] | undefined;
    set systemPackages(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _useEbsOptimizedInstances?;
    get useEbsOptimizedInstances(): boolean | undefined;
    set useEbsOptimizedInstances(value: boolean | undefined);
    private _ebsVolume?;
    get ebsVolume(): OpsworksJavaAppLayerEbsVolume[] | undefined;
    set ebsVolume(value: OpsworksJavaAppLayerEbsVolume[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
