"use strict";
// https://www.terraform.io/docs/providers/aws/r/opsworks_mysql_layer.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksMysqlLayer = void 0;
const cdktf_1 = require("cdktf");
// Resource
class OpsworksMysqlLayer extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_opsworks_mysql_layer',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._autoAssignElasticIps = config.autoAssignElasticIps;
        this._autoAssignPublicIps = config.autoAssignPublicIps;
        this._autoHealing = config.autoHealing;
        this._customConfigureRecipes = config.customConfigureRecipes;
        this._customDeployRecipes = config.customDeployRecipes;
        this._customInstanceProfileArn = config.customInstanceProfileArn;
        this._customJson = config.customJson;
        this._customSecurityGroupIds = config.customSecurityGroupIds;
        this._customSetupRecipes = config.customSetupRecipes;
        this._customShutdownRecipes = config.customShutdownRecipes;
        this._customUndeployRecipes = config.customUndeployRecipes;
        this._drainElbOnShutdown = config.drainElbOnShutdown;
        this._elasticLoadBalancer = config.elasticLoadBalancer;
        this._installUpdatesOnBoot = config.installUpdatesOnBoot;
        this._instanceShutdownTimeout = config.instanceShutdownTimeout;
        this._name = config.name;
        this._rootPassword = config.rootPassword;
        this._rootPasswordOnAllInstances = config.rootPasswordOnAllInstances;
        this._stackId = config.stackId;
        this._systemPackages = config.systemPackages;
        this._tags = config.tags;
        this._useEbsOptimizedInstances = config.useEbsOptimizedInstances;
        this._ebsVolume = config.ebsVolume;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get autoAssignElasticIps() {
        return this._autoAssignElasticIps;
    }
    set autoAssignElasticIps(value) {
        this._autoAssignElasticIps = value;
    }
    get autoAssignPublicIps() {
        return this._autoAssignPublicIps;
    }
    set autoAssignPublicIps(value) {
        this._autoAssignPublicIps = value;
    }
    get autoHealing() {
        return this._autoHealing;
    }
    set autoHealing(value) {
        this._autoHealing = value;
    }
    get customConfigureRecipes() {
        return this._customConfigureRecipes;
    }
    set customConfigureRecipes(value) {
        this._customConfigureRecipes = value;
    }
    get customDeployRecipes() {
        return this._customDeployRecipes;
    }
    set customDeployRecipes(value) {
        this._customDeployRecipes = value;
    }
    get customInstanceProfileArn() {
        return this._customInstanceProfileArn;
    }
    set customInstanceProfileArn(value) {
        this._customInstanceProfileArn = value;
    }
    get customJson() {
        return this._customJson;
    }
    set customJson(value) {
        this._customJson = value;
    }
    get customSecurityGroupIds() {
        return this._customSecurityGroupIds;
    }
    set customSecurityGroupIds(value) {
        this._customSecurityGroupIds = value;
    }
    get customSetupRecipes() {
        return this._customSetupRecipes;
    }
    set customSetupRecipes(value) {
        this._customSetupRecipes = value;
    }
    get customShutdownRecipes() {
        return this._customShutdownRecipes;
    }
    set customShutdownRecipes(value) {
        this._customShutdownRecipes = value;
    }
    get customUndeployRecipes() {
        return this._customUndeployRecipes;
    }
    set customUndeployRecipes(value) {
        this._customUndeployRecipes = value;
    }
    get drainElbOnShutdown() {
        return this._drainElbOnShutdown;
    }
    set drainElbOnShutdown(value) {
        this._drainElbOnShutdown = value;
    }
    get elasticLoadBalancer() {
        return this._elasticLoadBalancer;
    }
    set elasticLoadBalancer(value) {
        this._elasticLoadBalancer = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get installUpdatesOnBoot() {
        return this._installUpdatesOnBoot;
    }
    set installUpdatesOnBoot(value) {
        this._installUpdatesOnBoot = value;
    }
    get instanceShutdownTimeout() {
        return this._instanceShutdownTimeout;
    }
    set instanceShutdownTimeout(value) {
        this._instanceShutdownTimeout = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get rootPassword() {
        return this._rootPassword;
    }
    set rootPassword(value) {
        this._rootPassword = value;
    }
    get rootPasswordOnAllInstances() {
        return this._rootPasswordOnAllInstances;
    }
    set rootPasswordOnAllInstances(value) {
        this._rootPasswordOnAllInstances = value;
    }
    get stackId() {
        return this._stackId;
    }
    set stackId(value) {
        this._stackId = value;
    }
    get systemPackages() {
        return this._systemPackages;
    }
    set systemPackages(value) {
        this._systemPackages = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get useEbsOptimizedInstances() {
        return this._useEbsOptimizedInstances;
    }
    set useEbsOptimizedInstances(value) {
        this._useEbsOptimizedInstances = value;
    }
    get ebsVolume() {
        return this._ebsVolume;
    }
    set ebsVolume(value) {
        this._ebsVolume = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_assign_elastic_ips: this._autoAssignElasticIps,
            auto_assign_public_ips: this._autoAssignPublicIps,
            auto_healing: this._autoHealing,
            custom_configure_recipes: this._customConfigureRecipes,
            custom_deploy_recipes: this._customDeployRecipes,
            custom_instance_profile_arn: this._customInstanceProfileArn,
            custom_json: this._customJson,
            custom_security_group_ids: this._customSecurityGroupIds,
            custom_setup_recipes: this._customSetupRecipes,
            custom_shutdown_recipes: this._customShutdownRecipes,
            custom_undeploy_recipes: this._customUndeployRecipes,
            drain_elb_on_shutdown: this._drainElbOnShutdown,
            elastic_load_balancer: this._elasticLoadBalancer,
            install_updates_on_boot: this._installUpdatesOnBoot,
            instance_shutdown_timeout: this._instanceShutdownTimeout,
            name: this._name,
            root_password: this._rootPassword,
            root_password_on_all_instances: this._rootPasswordOnAllInstances,
            stack_id: this._stackId,
            system_packages: this._systemPackages,
            tags: this._tags,
            use_ebs_optimized_instances: this._useEbsOptimizedInstances,
            ebs_volume: this._ebsVolume,
        };
    }
}
exports.OpsworksMysqlLayer = OpsworksMysqlLayer;
//# sourceMappingURL=data:application/json;base64,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