import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OpsworksStackConfig extends TerraformMetaArguments {
    readonly agentVersion?: string;
    readonly berkshelfVersion?: string;
    readonly color?: string;
    readonly configurationManagerName?: string;
    readonly configurationManagerVersion?: string;
    readonly customJson?: string;
    readonly defaultAvailabilityZone?: string;
    readonly defaultInstanceProfileArn: string;
    readonly defaultOs?: string;
    readonly defaultRootDeviceType?: string;
    readonly defaultSshKeyName?: string;
    readonly defaultSubnetId?: string;
    readonly hostnameTheme?: string;
    readonly manageBerkshelf?: boolean;
    readonly name: string;
    readonly region: string;
    readonly serviceRoleArn: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly useCustomCookbooks?: boolean;
    readonly useOpsworksSecurityGroups?: boolean;
    readonly vpcId?: string;
    /** custom_cookbooks_source block */
    readonly customCookbooksSource?: OpsworksStackCustomCookbooksSource[];
}
export interface OpsworksStackCustomCookbooksSource {
    readonly password?: string;
    readonly revision?: string;
    readonly sshKey?: string;
    readonly type: string;
    readonly url: string;
    readonly username?: string;
}
export declare class OpsworksStack extends TerraformResource {
    constructor(scope: Construct, id: string, config: OpsworksStackConfig);
    private _agentVersion?;
    get agentVersion(): string | undefined;
    set agentVersion(value: string | undefined);
    get arn(): string;
    private _berkshelfVersion?;
    get berkshelfVersion(): string | undefined;
    set berkshelfVersion(value: string | undefined);
    private _color?;
    get color(): string | undefined;
    set color(value: string | undefined);
    private _configurationManagerName?;
    get configurationManagerName(): string | undefined;
    set configurationManagerName(value: string | undefined);
    private _configurationManagerVersion?;
    get configurationManagerVersion(): string | undefined;
    set configurationManagerVersion(value: string | undefined);
    private _customJson?;
    get customJson(): string | undefined;
    set customJson(value: string | undefined);
    private _defaultAvailabilityZone?;
    get defaultAvailabilityZone(): string | undefined;
    set defaultAvailabilityZone(value: string | undefined);
    private _defaultInstanceProfileArn;
    get defaultInstanceProfileArn(): string;
    set defaultInstanceProfileArn(value: string);
    private _defaultOs?;
    get defaultOs(): string | undefined;
    set defaultOs(value: string | undefined);
    private _defaultRootDeviceType?;
    get defaultRootDeviceType(): string | undefined;
    set defaultRootDeviceType(value: string | undefined);
    private _defaultSshKeyName?;
    get defaultSshKeyName(): string | undefined;
    set defaultSshKeyName(value: string | undefined);
    private _defaultSubnetId?;
    get defaultSubnetId(): string | undefined;
    set defaultSubnetId(value: string | undefined);
    private _hostnameTheme?;
    get hostnameTheme(): string | undefined;
    set hostnameTheme(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _manageBerkshelf?;
    get manageBerkshelf(): boolean | undefined;
    set manageBerkshelf(value: boolean | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _region;
    get region(): string;
    set region(value: string);
    private _serviceRoleArn;
    get serviceRoleArn(): string;
    set serviceRoleArn(value: string);
    get stackEndpoint(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _useCustomCookbooks?;
    get useCustomCookbooks(): boolean | undefined;
    set useCustomCookbooks(value: boolean | undefined);
    private _useOpsworksSecurityGroups?;
    get useOpsworksSecurityGroups(): boolean | undefined;
    set useOpsworksSecurityGroups(value: boolean | undefined);
    private _vpcId?;
    get vpcId(): string | undefined;
    set vpcId(value: string | undefined);
    private _customCookbooksSource?;
    get customCookbooksSource(): OpsworksStackCustomCookbooksSource[] | undefined;
    set customCookbooksSource(value: OpsworksStackCustomCookbooksSource[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
