"use strict";
// https://www.terraform.io/docs/providers/aws/r/opsworks_stack.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpsworksStack = void 0;
const cdktf_1 = require("cdktf");
// Resource
class OpsworksStack extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_opsworks_stack',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._agentVersion = config.agentVersion;
        this._berkshelfVersion = config.berkshelfVersion;
        this._color = config.color;
        this._configurationManagerName = config.configurationManagerName;
        this._configurationManagerVersion = config.configurationManagerVersion;
        this._customJson = config.customJson;
        this._defaultAvailabilityZone = config.defaultAvailabilityZone;
        this._defaultInstanceProfileArn = config.defaultInstanceProfileArn;
        this._defaultOs = config.defaultOs;
        this._defaultRootDeviceType = config.defaultRootDeviceType;
        this._defaultSshKeyName = config.defaultSshKeyName;
        this._defaultSubnetId = config.defaultSubnetId;
        this._hostnameTheme = config.hostnameTheme;
        this._manageBerkshelf = config.manageBerkshelf;
        this._name = config.name;
        this._region = config.region;
        this._serviceRoleArn = config.serviceRoleArn;
        this._tags = config.tags;
        this._useCustomCookbooks = config.useCustomCookbooks;
        this._useOpsworksSecurityGroups = config.useOpsworksSecurityGroups;
        this._vpcId = config.vpcId;
        this._customCookbooksSource = config.customCookbooksSource;
    }
    get agentVersion() {
        var _a;
        return (_a = this._agentVersion) !== null && _a !== void 0 ? _a : this.getStringAttribute('agent_version');
    }
    set agentVersion(value) {
        this._agentVersion = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get berkshelfVersion() {
        return this._berkshelfVersion;
    }
    set berkshelfVersion(value) {
        this._berkshelfVersion = value;
    }
    get color() {
        return this._color;
    }
    set color(value) {
        this._color = value;
    }
    get configurationManagerName() {
        return this._configurationManagerName;
    }
    set configurationManagerName(value) {
        this._configurationManagerName = value;
    }
    get configurationManagerVersion() {
        return this._configurationManagerVersion;
    }
    set configurationManagerVersion(value) {
        this._configurationManagerVersion = value;
    }
    get customJson() {
        return this._customJson;
    }
    set customJson(value) {
        this._customJson = value;
    }
    get defaultAvailabilityZone() {
        var _a;
        return (_a = this._defaultAvailabilityZone) !== null && _a !== void 0 ? _a : this.getStringAttribute('default_availability_zone');
    }
    set defaultAvailabilityZone(value) {
        this._defaultAvailabilityZone = value;
    }
    get defaultInstanceProfileArn() {
        return this._defaultInstanceProfileArn;
    }
    set defaultInstanceProfileArn(value) {
        this._defaultInstanceProfileArn = value;
    }
    get defaultOs() {
        return this._defaultOs;
    }
    set defaultOs(value) {
        this._defaultOs = value;
    }
    get defaultRootDeviceType() {
        return this._defaultRootDeviceType;
    }
    set defaultRootDeviceType(value) {
        this._defaultRootDeviceType = value;
    }
    get defaultSshKeyName() {
        return this._defaultSshKeyName;
    }
    set defaultSshKeyName(value) {
        this._defaultSshKeyName = value;
    }
    get defaultSubnetId() {
        var _a;
        return (_a = this._defaultSubnetId) !== null && _a !== void 0 ? _a : this.getStringAttribute('default_subnet_id');
    }
    set defaultSubnetId(value) {
        this._defaultSubnetId = value;
    }
    get hostnameTheme() {
        return this._hostnameTheme;
    }
    set hostnameTheme(value) {
        this._hostnameTheme = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get manageBerkshelf() {
        return this._manageBerkshelf;
    }
    set manageBerkshelf(value) {
        this._manageBerkshelf = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get region() {
        return this._region;
    }
    set region(value) {
        this._region = value;
    }
    get serviceRoleArn() {
        return this._serviceRoleArn;
    }
    set serviceRoleArn(value) {
        this._serviceRoleArn = value;
    }
    // stack_endpoint - computed: true, optional: false, required: true
    get stackEndpoint() {
        return this.getStringAttribute('stack_endpoint');
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get useCustomCookbooks() {
        return this._useCustomCookbooks;
    }
    set useCustomCookbooks(value) {
        this._useCustomCookbooks = value;
    }
    get useOpsworksSecurityGroups() {
        return this._useOpsworksSecurityGroups;
    }
    set useOpsworksSecurityGroups(value) {
        this._useOpsworksSecurityGroups = value;
    }
    get vpcId() {
        var _a;
        return (_a = this._vpcId) !== null && _a !== void 0 ? _a : this.getStringAttribute('vpc_id');
    }
    set vpcId(value) {
        this._vpcId = value;
    }
    get customCookbooksSource() {
        return this._customCookbooksSource;
    }
    set customCookbooksSource(value) {
        this._customCookbooksSource = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            agent_version: this._agentVersion,
            berkshelf_version: this._berkshelfVersion,
            color: this._color,
            configuration_manager_name: this._configurationManagerName,
            configuration_manager_version: this._configurationManagerVersion,
            custom_json: this._customJson,
            default_availability_zone: this._defaultAvailabilityZone,
            default_instance_profile_arn: this._defaultInstanceProfileArn,
            default_os: this._defaultOs,
            default_root_device_type: this._defaultRootDeviceType,
            default_ssh_key_name: this._defaultSshKeyName,
            default_subnet_id: this._defaultSubnetId,
            hostname_theme: this._hostnameTheme,
            manage_berkshelf: this._manageBerkshelf,
            name: this._name,
            region: this._region,
            service_role_arn: this._serviceRoleArn,
            tags: this._tags,
            use_custom_cookbooks: this._useCustomCookbooks,
            use_opsworks_security_groups: this._useOpsworksSecurityGroups,
            vpc_id: this._vpcId,
            custom_cookbooks_source: this._customCookbooksSource,
        };
    }
}
exports.OpsworksStack = OpsworksStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3Bzd29ya3Mtc3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvb3Bzd29ya3Mtc3RhY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSwyQ0FBMkM7OztBQXVKM0MsaUNBQTBDO0FBdUMxQyxXQUFXO0FBRVgsTUFBYSxhQUFjLFNBQVEseUJBQWlCO0lBRWxELGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTJCO1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsb0JBQW9CO1lBQzNDLDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsS0FBSzthQUNwQjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxZQUFZLENBQUM7UUFDekMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLHlCQUF5QixHQUFHLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQztRQUNqRSxJQUFJLENBQUMsNEJBQTRCLEdBQUcsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBQ3ZFLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsd0JBQXdCLEdBQUcsTUFBTSxDQUFDLHVCQUF1QixDQUFDO1FBQy9ELElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDLE1BQU0sQ0FBQztRQUM3QixJQUFJLENBQUMsZUFBZSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7UUFDN0MsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQztJQUM3RCxDQUFDO0lBUUQsSUFBVyxZQUFZOztRQUNyQixhQUFPLElBQUksQ0FBQyxhQUFhLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUN4RSxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBeUI7UUFDL0MsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7SUFDN0IsQ0FBQztJQUVELHdEQUF3RDtJQUN4RCxJQUFXLEdBQUc7UUFDWixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBeUI7UUFDbkQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxLQUFLO1FBQ2QsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDO0lBQ3JCLENBQUM7SUFDRCxJQUFXLEtBQUssQ0FBQyxLQUF5QjtRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMseUJBQXlCLENBQUM7SUFDeEMsQ0FBQztJQUNELElBQVcsd0JBQXdCLENBQUMsS0FBeUI7UUFDM0QsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVywyQkFBMkI7UUFDcEMsT0FBTyxJQUFJLENBQUMsNEJBQTRCLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsMkJBQTJCLENBQUMsS0FBeUI7UUFDOUQsSUFBSSxDQUFDLDRCQUE0QixHQUFHLEtBQUssQ0FBQztJQUM1QyxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBeUI7UUFDN0MsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7SUFDM0IsQ0FBQztJQUlELElBQVcsdUJBQXVCOztRQUNoQyxhQUFPLElBQUksQ0FBQyx3QkFBd0IsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLDJCQUEyQixDQUFDLENBQUM7SUFDL0YsQ0FBQztJQUNELElBQVcsdUJBQXVCLENBQUMsS0FBeUI7UUFDMUQsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBYTtRQUNoRCxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFDRCxJQUFXLFNBQVMsQ0FBQyxLQUF5QjtRQUM1QyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUNELElBQVcscUJBQXFCLENBQUMsS0FBeUI7UUFDeEQsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBeUI7UUFDcEQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxlQUFlOztRQUN4QixhQUFPLElBQUksQ0FBQyxnQkFBZ0IsbUNBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDL0UsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQXlCO1FBQ2xELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxjQUFjLENBQUM7SUFDN0IsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQXlCO1FBQ2hELElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFJRCxJQUFXLEVBQUU7O1FBQ1gsYUFBTyxJQUFJLENBQUMsR0FBRyxtQ0FBSSxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQXlCO1FBQ3JDLElBQUksQ0FBQyxHQUFHLEdBQUcsS0FBSyxDQUFDO0lBQ25CLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQTBCO1FBQ25ELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDO0lBQzlCLENBQUM7SUFDRCxJQUFXLGNBQWMsQ0FBQyxLQUFhO1FBQ3JDLElBQUksQ0FBQyxlQUFlLEdBQUcsS0FBSyxDQUFDO0lBQy9CLENBQUM7SUFFRCxtRUFBbUU7SUFDbkUsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBNEM7UUFDMUQsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQTBCO1FBQ3RELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQTBCO1FBQzdELElBQUksQ0FBQywwQkFBMEIsR0FBRyxLQUFLLENBQUM7SUFDMUMsQ0FBQztJQUlELElBQVcsS0FBSzs7UUFDZCxhQUFPLElBQUksQ0FBQyxNQUFNLG1DQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxLQUFLLENBQUMsS0FBeUI7UUFDeEMsSUFBSSxDQUFDLE1BQU0sR0FBRyxLQUFLLENBQUM7SUFDdEIsQ0FBQztJQUlELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLHNCQUFzQixDQUFDO0lBQ3JDLENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQXVEO1FBQ3RGLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVMLG9CQUFvQjtRQUN6QixPQUFPO1lBQ0wsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO1lBQ2pDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsS0FBSyxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ2xCLDBCQUEwQixFQUFFLElBQUksQ0FBQyx5QkFBeUI7WUFDMUQsNkJBQTZCLEVBQUUsSUFBSSxDQUFDLDRCQUE0QjtZQUNoRSxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVc7WUFDN0IseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QjtZQUN4RCw0QkFBNEIsRUFBRSxJQUFJLENBQUMsMEJBQTBCO1lBQzdELFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVTtZQUMzQix3QkFBd0IsRUFBRSxJQUFJLENBQUMsc0JBQXNCO1lBQ3JELG9CQUFvQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDN0MsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN4QyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxJQUFJLEVBQUUsSUFBSSxDQUFDLEtBQUs7WUFDaEIsTUFBTSxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3BCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxlQUFlO1lBQ3RDLElBQUksRUFBRSxJQUFJLENBQUMsS0FBSztZQUNoQixvQkFBb0IsRUFBRSxJQUFJLENBQUMsbUJBQW1CO1lBQzlDLDRCQUE0QixFQUFFLElBQUksQ0FBQywwQkFBMEI7WUFDN0QsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNO1lBQ25CLHVCQUF1QixFQUFFLElBQUksQ0FBQyxzQkFBc0I7U0FDckQsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQXBTRCxzQ0FvU0MiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXdzL3Ivb3Bzd29ya3Nfc3RhY2suaHRtbFxuLy8gZ2VuZXJhdGVkIGZyb20gdGVycmFmb3JtIHJlc291cmNlIHNjaGVtYVxuXG4vKlxue1xuICBcInZlcnNpb25cIjogMCxcbiAgXCJibG9ja1wiOiB7XG4gICAgXCJhdHRyaWJ1dGVzXCI6IHtcbiAgICAgIFwiYWdlbnRfdmVyc2lvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYXJuXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiYmVya3NoZWxmX3ZlcnNpb25cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJjb2xvclwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImNvbmZpZ3VyYXRpb25fbWFuYWdlcl9uYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiY29uZmlndXJhdGlvbl9tYW5hZ2VyX3ZlcnNpb25cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJjdXN0b21fanNvblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImRlZmF1bHRfYXZhaWxhYmlsaXR5X3pvbmVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcImRlZmF1bHRfaW5zdGFuY2VfcHJvZmlsZV9hcm5cIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJkZWZhdWx0X29zXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZGVmYXVsdF9yb290X2RldmljZV90eXBlXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiZGVmYXVsdF9zc2hfa2V5X25hbWVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJkZWZhdWx0X3N1Ym5ldF9pZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwiaG9zdG5hbWVfdGhlbWVcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJpZFwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwibWFuYWdlX2JlcmtzaGVsZlwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJuYW1lXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwicmVnaW9uXCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwicmVxdWlyZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwic2VydmljZV9yb2xlX2FyblwiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICBcInJlcXVpcmVkXCI6IHRydWVcbiAgICAgIH0sXG4gICAgICBcInN0YWNrX2VuZHBvaW50XCI6IHtcbiAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgIFwiY29tcHV0ZWRcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidGFnc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBbXG4gICAgICAgICAgXCJtYXBcIixcbiAgICAgICAgICBcInN0cmluZ1wiXG4gICAgICAgIF0sXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidXNlX2N1c3RvbV9jb29rYm9va3NcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJib29sXCIsXG4gICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgfSxcbiAgICAgIFwidXNlX29wc3dvcmtzX3NlY3VyaXR5X2dyb3Vwc1wiOiB7XG4gICAgICAgIFwidHlwZVwiOiBcImJvb2xcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlXG4gICAgICB9LFxuICAgICAgXCJ2cGNfaWRcIjoge1xuICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgXCJvcHRpb25hbFwiOiB0cnVlLFxuICAgICAgICBcImNvbXB1dGVkXCI6IHRydWVcbiAgICAgIH1cbiAgICB9LFxuICAgIFwiYmxvY2tfdHlwZXNcIjoge1xuICAgICAgXCJjdXN0b21fY29va2Jvb2tzX3NvdXJjZVwiOiB7XG4gICAgICAgIFwibmVzdGluZ19tb2RlXCI6IFwibGlzdFwiLFxuICAgICAgICBcImJsb2NrXCI6IHtcbiAgICAgICAgICBcImF0dHJpYnV0ZXNcIjoge1xuICAgICAgICAgICAgXCJwYXNzd29yZFwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgIFwic2Vuc2l0aXZlXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInJldmlzaW9uXCI6IHtcbiAgICAgICAgICAgICAgXCJ0eXBlXCI6IFwic3RyaW5nXCIsXG4gICAgICAgICAgICAgIFwib3B0aW9uYWxcIjogdHJ1ZVxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIFwic3NoX2tleVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWUsXG4gICAgICAgICAgICAgIFwic2Vuc2l0aXZlXCI6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBcInR5cGVcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJ1cmxcIjoge1xuICAgICAgICAgICAgICBcInR5cGVcIjogXCJzdHJpbmdcIixcbiAgICAgICAgICAgICAgXCJyZXF1aXJlZFwiOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgXCJ1c2VybmFtZVwiOiB7XG4gICAgICAgICAgICAgIFwidHlwZVwiOiBcInN0cmluZ1wiLFxuICAgICAgICAgICAgICBcIm9wdGlvbmFsXCI6IHRydWVcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cbiovXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IFRlcnJhZm9ybVJlc291cmNlIH0gZnJvbSAnY2RrdGYnO1xuaW1wb3J0IHsgVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB9IGZyb20gJ2Nka3RmJztcblxuLy8gQ29uZmlndXJhdGlvblxuXG5leHBvcnQgaW50ZXJmYWNlIE9wc3dvcmtzU3RhY2tDb25maWcgZXh0ZW5kcyBUZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgcmVhZG9ubHkgYWdlbnRWZXJzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBiZXJrc2hlbGZWZXJzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBjb2xvcj86IHN0cmluZztcbiAgcmVhZG9ubHkgY29uZmlndXJhdGlvbk1hbmFnZXJOYW1lPzogc3RyaW5nO1xuICByZWFkb25seSBjb25maWd1cmF0aW9uTWFuYWdlclZlcnNpb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGN1c3RvbUpzb24/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlZmF1bHRBdmFpbGFiaWxpdHlab25lPzogc3RyaW5nO1xuICByZWFkb25seSBkZWZhdWx0SW5zdGFuY2VQcm9maWxlQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlZmF1bHRPcz86IHN0cmluZztcbiAgcmVhZG9ubHkgZGVmYXVsdFJvb3REZXZpY2VUeXBlPzogc3RyaW5nO1xuICByZWFkb25seSBkZWZhdWx0U3NoS2V5TmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgZGVmYXVsdFN1Ym5ldElkPzogc3RyaW5nO1xuICByZWFkb25seSBob3N0bmFtZVRoZW1lPzogc3RyaW5nO1xuICByZWFkb25seSBtYW5hZ2VCZXJrc2hlbGY/OiBib29sZWFuO1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJlZ2lvbjogc3RyaW5nO1xuICByZWFkb25seSBzZXJ2aWNlUm9sZUFybjogc3RyaW5nO1xuICByZWFkb25seSB0YWdzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgcmVhZG9ubHkgdXNlQ3VzdG9tQ29va2Jvb2tzPzogYm9vbGVhbjtcbiAgcmVhZG9ubHkgdXNlT3Bzd29ya3NTZWN1cml0eUdyb3Vwcz86IGJvb2xlYW47XG4gIHJlYWRvbmx5IHZwY0lkPzogc3RyaW5nO1xuICAvKiogY3VzdG9tX2Nvb2tib29rc19zb3VyY2UgYmxvY2sgKi9cbiAgcmVhZG9ubHkgY3VzdG9tQ29va2Jvb2tzU291cmNlPzogT3Bzd29ya3NTdGFja0N1c3RvbUNvb2tib29rc1NvdXJjZVtdO1xufVxuZXhwb3J0IGludGVyZmFjZSBPcHN3b3Jrc1N0YWNrQ3VzdG9tQ29va2Jvb2tzU291cmNlIHtcbiAgcmVhZG9ubHkgcGFzc3dvcmQ/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHJldmlzaW9uPzogc3RyaW5nO1xuICByZWFkb25seSBzc2hLZXk/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHR5cGU6IHN0cmluZztcbiAgcmVhZG9ubHkgdXJsOiBzdHJpbmc7XG4gIHJlYWRvbmx5IHVzZXJuYW1lPzogc3RyaW5nO1xufVxuXG4vLyBSZXNvdXJjZVxuXG5leHBvcnQgY2xhc3MgT3Bzd29ya3NTdGFjayBleHRlbmRzIFRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IE9wc3dvcmtzU3RhY2tDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2F3c19vcHN3b3Jrc19zdGFjaycsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdhd3MnXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9hZ2VudFZlcnNpb24gPSBjb25maWcuYWdlbnRWZXJzaW9uO1xuICAgIHRoaXMuX2JlcmtzaGVsZlZlcnNpb24gPSBjb25maWcuYmVya3NoZWxmVmVyc2lvbjtcbiAgICB0aGlzLl9jb2xvciA9IGNvbmZpZy5jb2xvcjtcbiAgICB0aGlzLl9jb25maWd1cmF0aW9uTWFuYWdlck5hbWUgPSBjb25maWcuY29uZmlndXJhdGlvbk1hbmFnZXJOYW1lO1xuICAgIHRoaXMuX2NvbmZpZ3VyYXRpb25NYW5hZ2VyVmVyc2lvbiA9IGNvbmZpZy5jb25maWd1cmF0aW9uTWFuYWdlclZlcnNpb247XG4gICAgdGhpcy5fY3VzdG9tSnNvbiA9IGNvbmZpZy5jdXN0b21Kc29uO1xuICAgIHRoaXMuX2RlZmF1bHRBdmFpbGFiaWxpdHlab25lID0gY29uZmlnLmRlZmF1bHRBdmFpbGFiaWxpdHlab25lO1xuICAgIHRoaXMuX2RlZmF1bHRJbnN0YW5jZVByb2ZpbGVBcm4gPSBjb25maWcuZGVmYXVsdEluc3RhbmNlUHJvZmlsZUFybjtcbiAgICB0aGlzLl9kZWZhdWx0T3MgPSBjb25maWcuZGVmYXVsdE9zO1xuICAgIHRoaXMuX2RlZmF1bHRSb290RGV2aWNlVHlwZSA9IGNvbmZpZy5kZWZhdWx0Um9vdERldmljZVR5cGU7XG4gICAgdGhpcy5fZGVmYXVsdFNzaEtleU5hbWUgPSBjb25maWcuZGVmYXVsdFNzaEtleU5hbWU7XG4gICAgdGhpcy5fZGVmYXVsdFN1Ym5ldElkID0gY29uZmlnLmRlZmF1bHRTdWJuZXRJZDtcbiAgICB0aGlzLl9ob3N0bmFtZVRoZW1lID0gY29uZmlnLmhvc3RuYW1lVGhlbWU7XG4gICAgdGhpcy5fbWFuYWdlQmVya3NoZWxmID0gY29uZmlnLm1hbmFnZUJlcmtzaGVsZjtcbiAgICB0aGlzLl9uYW1lID0gY29uZmlnLm5hbWU7XG4gICAgdGhpcy5fcmVnaW9uID0gY29uZmlnLnJlZ2lvbjtcbiAgICB0aGlzLl9zZXJ2aWNlUm9sZUFybiA9IGNvbmZpZy5zZXJ2aWNlUm9sZUFybjtcbiAgICB0aGlzLl90YWdzID0gY29uZmlnLnRhZ3M7XG4gICAgdGhpcy5fdXNlQ3VzdG9tQ29va2Jvb2tzID0gY29uZmlnLnVzZUN1c3RvbUNvb2tib29rcztcbiAgICB0aGlzLl91c2VPcHN3b3Jrc1NlY3VyaXR5R3JvdXBzID0gY29uZmlnLnVzZU9wc3dvcmtzU2VjdXJpdHlHcm91cHM7XG4gICAgdGhpcy5fdnBjSWQgPSBjb25maWcudnBjSWQ7XG4gICAgdGhpcy5fY3VzdG9tQ29va2Jvb2tzU291cmNlID0gY29uZmlnLmN1c3RvbUNvb2tib29rc1NvdXJjZTtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gYWdlbnRfdmVyc2lvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FnZW50VmVyc2lvbj86IHN0cmluZztcbiAgcHVibGljIGdldCBhZ2VudFZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FnZW50VmVyc2lvbiA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYWdlbnRfdmVyc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWdlbnRWZXJzaW9uKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9hZ2VudFZlcnNpb24gPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGFybiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHB1YmxpYyBnZXQgYXJuKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnYXJuJyk7XG4gIH1cblxuICAvLyBiZXJrc2hlbGZfdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9iZXJrc2hlbGZWZXJzaW9uPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGJlcmtzaGVsZlZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuX2JlcmtzaGVsZlZlcnNpb247XG4gIH1cbiAgcHVibGljIHNldCBiZXJrc2hlbGZWZXJzaW9uKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9iZXJrc2hlbGZWZXJzaW9uID0gdmFsdWU7XG4gIH1cblxuICAvLyBjb2xvciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb2xvcj86IHN0cmluZztcbiAgcHVibGljIGdldCBjb2xvcigpIHtcbiAgICByZXR1cm4gdGhpcy5fY29sb3I7XG4gIH1cbiAgcHVibGljIHNldCBjb2xvcih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY29sb3IgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGNvbmZpZ3VyYXRpb25fbWFuYWdlcl9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbmZpZ3VyYXRpb25NYW5hZ2VyTmFtZT86IHN0cmluZztcbiAgcHVibGljIGdldCBjb25maWd1cmF0aW9uTWFuYWdlck5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NvbmZpZ3VyYXRpb25NYW5hZ2VyTmFtZTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbmZpZ3VyYXRpb25NYW5hZ2VyTmFtZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY29uZmlndXJhdGlvbk1hbmFnZXJOYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyBjb25maWd1cmF0aW9uX21hbmFnZXJfdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb25maWd1cmF0aW9uTWFuYWdlclZlcnNpb24/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgY29uZmlndXJhdGlvbk1hbmFnZXJWZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9jb25maWd1cmF0aW9uTWFuYWdlclZlcnNpb247XG4gIH1cbiAgcHVibGljIHNldCBjb25maWd1cmF0aW9uTWFuYWdlclZlcnNpb24odmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2NvbmZpZ3VyYXRpb25NYW5hZ2VyVmVyc2lvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gY3VzdG9tX2pzb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3VzdG9tSnNvbj86IHN0cmluZztcbiAgcHVibGljIGdldCBjdXN0b21Kc29uKCkge1xuICAgIHJldHVybiB0aGlzLl9jdXN0b21Kc29uO1xuICB9XG4gIHB1YmxpYyBzZXQgY3VzdG9tSnNvbih2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fY3VzdG9tSnNvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVmYXVsdF9hdmFpbGFiaWxpdHlfem9uZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlZmF1bHRBdmFpbGFiaWxpdHlab25lPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGRlZmF1bHRBdmFpbGFiaWxpdHlab25lKCkge1xuICAgIHJldHVybiB0aGlzLl9kZWZhdWx0QXZhaWxhYmlsaXR5Wm9uZSA/PyB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVmYXVsdF9hdmFpbGFiaWxpdHlfem9uZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVmYXVsdEF2YWlsYWJpbGl0eVpvbmUodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2RlZmF1bHRBdmFpbGFiaWxpdHlab25lID0gdmFsdWU7XG4gIH1cblxuICAvLyBkZWZhdWx0X2luc3RhbmNlX3Byb2ZpbGVfYXJuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX2RlZmF1bHRJbnN0YW5jZVByb2ZpbGVBcm46IHN0cmluZztcbiAgcHVibGljIGdldCBkZWZhdWx0SW5zdGFuY2VQcm9maWxlQXJuKCkge1xuICAgIHJldHVybiB0aGlzLl9kZWZhdWx0SW5zdGFuY2VQcm9maWxlQXJuO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVmYXVsdEluc3RhbmNlUHJvZmlsZUFybih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGVmYXVsdEluc3RhbmNlUHJvZmlsZUFybiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVmYXVsdF9vcyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWZhdWx0T3M/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgZGVmYXVsdE9zKCkge1xuICAgIHJldHVybiB0aGlzLl9kZWZhdWx0T3M7XG4gIH1cbiAgcHVibGljIHNldCBkZWZhdWx0T3ModmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2RlZmF1bHRPcyA9IHZhbHVlO1xuICB9XG5cbiAgLy8gZGVmYXVsdF9yb290X2RldmljZV90eXBlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlZmF1bHRSb290RGV2aWNlVHlwZT86IHN0cmluZztcbiAgcHVibGljIGdldCBkZWZhdWx0Um9vdERldmljZVR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlZmF1bHRSb290RGV2aWNlVHlwZTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlZmF1bHRSb290RGV2aWNlVHlwZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZGVmYXVsdFJvb3REZXZpY2VUeXBlID0gdmFsdWU7XG4gIH1cblxuICAvLyBkZWZhdWx0X3NzaF9rZXlfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWZhdWx0U3NoS2V5TmFtZT86IHN0cmluZztcbiAgcHVibGljIGdldCBkZWZhdWx0U3NoS2V5TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVmYXVsdFNzaEtleU5hbWU7XG4gIH1cbiAgcHVibGljIHNldCBkZWZhdWx0U3NoS2V5TmFtZSh2YWx1ZTogc3RyaW5nIHwgdW5kZWZpbmVkKSB7XG4gICAgdGhpcy5fZGVmYXVsdFNzaEtleU5hbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGRlZmF1bHRfc3VibmV0X2lkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVmYXVsdFN1Ym5ldElkPzogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IGRlZmF1bHRTdWJuZXRJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVmYXVsdFN1Ym5ldElkID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZWZhdWx0X3N1Ym5ldF9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVmYXVsdFN1Ym5ldElkKHZhbHVlOiBzdHJpbmcgfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9kZWZhdWx0U3VibmV0SWQgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGhvc3RuYW1lX3RoZW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2hvc3RuYW1lVGhlbWU/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaG9zdG5hbWVUaGVtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5faG9zdG5hbWVUaGVtZTtcbiAgfVxuICBwdWJsaWMgc2V0IGhvc3RuYW1lVGhlbWUodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2hvc3RuYW1lVGhlbWUgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfaWQ/OiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkID8/IHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cblxuICAvLyBtYW5hZ2VfYmVya3NoZWxmIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21hbmFnZUJlcmtzaGVsZj86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgbWFuYWdlQmVya3NoZWxmKCkge1xuICAgIHJldHVybiB0aGlzLl9tYW5hZ2VCZXJrc2hlbGY7XG4gIH1cbiAgcHVibGljIHNldCBtYW5hZ2VCZXJrc2hlbGYodmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl9tYW5hZ2VCZXJrc2hlbGYgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZTogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IG5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9uYW1lID0gdmFsdWU7XG4gIH1cblxuICAvLyByZWdpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfcmVnaW9uOiBzdHJpbmc7XG4gIHB1YmxpYyBnZXQgcmVnaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl9yZWdpb247XG4gIH1cbiAgcHVibGljIHNldCByZWdpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3JlZ2lvbiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc2VydmljZV9yb2xlX2FybiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9zZXJ2aWNlUm9sZUFybjogc3RyaW5nO1xuICBwdWJsaWMgZ2V0IHNlcnZpY2VSb2xlQXJuKCkge1xuICAgIHJldHVybiB0aGlzLl9zZXJ2aWNlUm9sZUFybjtcbiAgfVxuICBwdWJsaWMgc2V0IHNlcnZpY2VSb2xlQXJuKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zZXJ2aWNlUm9sZUFybiA9IHZhbHVlO1xuICB9XG5cbiAgLy8gc3RhY2tfZW5kcG9pbnQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwdWJsaWMgZ2V0IHN0YWNrRW5kcG9pbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdGFja19lbmRwb2ludCcpO1xuICB9XG5cbiAgLy8gdGFncyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90YWdzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcbiAgcHVibGljIGdldCB0YWdzKCkge1xuICAgIHJldHVybiB0aGlzLl90YWdzO1xuICB9XG4gIHB1YmxpYyBzZXQgdGFncyh2YWx1ZTogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3RhZ3MgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHVzZV9jdXN0b21fY29va2Jvb2tzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VzZUN1c3RvbUNvb2tib29rcz86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgdXNlQ3VzdG9tQ29va2Jvb2tzKCkge1xuICAgIHJldHVybiB0aGlzLl91c2VDdXN0b21Db29rYm9va3M7XG4gIH1cbiAgcHVibGljIHNldCB1c2VDdXN0b21Db29rYm9va3ModmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl91c2VDdXN0b21Db29rYm9va3MgPSB2YWx1ZTtcbiAgfVxuXG4gIC8vIHVzZV9vcHN3b3Jrc19zZWN1cml0eV9ncm91cHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXNlT3Bzd29ya3NTZWN1cml0eUdyb3Vwcz86IGJvb2xlYW47XG4gIHB1YmxpYyBnZXQgdXNlT3Bzd29ya3NTZWN1cml0eUdyb3VwcygpIHtcbiAgICByZXR1cm4gdGhpcy5fdXNlT3Bzd29ya3NTZWN1cml0eUdyb3VwcztcbiAgfVxuICBwdWJsaWMgc2V0IHVzZU9wc3dvcmtzU2VjdXJpdHlHcm91cHModmFsdWU6IGJvb2xlYW4gfCB1bmRlZmluZWQpIHtcbiAgICB0aGlzLl91c2VPcHN3b3Jrc1NlY3VyaXR5R3JvdXBzID0gdmFsdWU7XG4gIH1cblxuICAvLyB2cGNfaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF92cGNJZD86IHN0cmluZztcbiAgcHVibGljIGdldCB2cGNJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdnBjSWQgPz8gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3ZwY19pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgdnBjSWQodmFsdWU6IHN0cmluZyB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX3ZwY0lkID0gdmFsdWU7XG4gIH1cblxuICAvLyBjdXN0b21fY29va2Jvb2tzX3NvdXJjZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jdXN0b21Db29rYm9va3NTb3VyY2U/OiBPcHN3b3Jrc1N0YWNrQ3VzdG9tQ29va2Jvb2tzU291cmNlW107XG4gIHB1YmxpYyBnZXQgY3VzdG9tQ29va2Jvb2tzU291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLl9jdXN0b21Db29rYm9va3NTb3VyY2U7XG4gIH1cbiAgcHVibGljIHNldCBjdXN0b21Db29rYm9va3NTb3VyY2UodmFsdWU6IE9wc3dvcmtzU3RhY2tDdXN0b21Db29rYm9va3NTb3VyY2VbXSB8IHVuZGVmaW5lZCkge1xuICAgIHRoaXMuX2N1c3RvbUNvb2tib29rc1NvdXJjZSA9IHZhbHVlO1xuICB9XG5cbiAgLy8gPT09PT09PT09XG4gIC8vIFNZTlRIRVNJU1xuICAvLyA9PT09PT09PT1cblxuICBwdWJsaWMgc3ludGhlc2l6ZUF0dHJpYnV0ZXMoKTogeyBbbmFtZTogc3RyaW5nXTogYW55IH0ge1xuICAgIHJldHVybiB7XG4gICAgICBhZ2VudF92ZXJzaW9uOiB0aGlzLl9hZ2VudFZlcnNpb24sXG4gICAgICBiZXJrc2hlbGZfdmVyc2lvbjogdGhpcy5fYmVya3NoZWxmVmVyc2lvbixcbiAgICAgIGNvbG9yOiB0aGlzLl9jb2xvcixcbiAgICAgIGNvbmZpZ3VyYXRpb25fbWFuYWdlcl9uYW1lOiB0aGlzLl9jb25maWd1cmF0aW9uTWFuYWdlck5hbWUsXG4gICAgICBjb25maWd1cmF0aW9uX21hbmFnZXJfdmVyc2lvbjogdGhpcy5fY29uZmlndXJhdGlvbk1hbmFnZXJWZXJzaW9uLFxuICAgICAgY3VzdG9tX2pzb246IHRoaXMuX2N1c3RvbUpzb24sXG4gICAgICBkZWZhdWx0X2F2YWlsYWJpbGl0eV96b25lOiB0aGlzLl9kZWZhdWx0QXZhaWxhYmlsaXR5Wm9uZSxcbiAgICAgIGRlZmF1bHRfaW5zdGFuY2VfcHJvZmlsZV9hcm46IHRoaXMuX2RlZmF1bHRJbnN0YW5jZVByb2ZpbGVBcm4sXG4gICAgICBkZWZhdWx0X29zOiB0aGlzLl9kZWZhdWx0T3MsXG4gICAgICBkZWZhdWx0X3Jvb3RfZGV2aWNlX3R5cGU6IHRoaXMuX2RlZmF1bHRSb290RGV2aWNlVHlwZSxcbiAgICAgIGRlZmF1bHRfc3NoX2tleV9uYW1lOiB0aGlzLl9kZWZhdWx0U3NoS2V5TmFtZSxcbiAgICAgIGRlZmF1bHRfc3VibmV0X2lkOiB0aGlzLl9kZWZhdWx0U3VibmV0SWQsXG4gICAgICBob3N0bmFtZV90aGVtZTogdGhpcy5faG9zdG5hbWVUaGVtZSxcbiAgICAgIG1hbmFnZV9iZXJrc2hlbGY6IHRoaXMuX21hbmFnZUJlcmtzaGVsZixcbiAgICAgIG5hbWU6IHRoaXMuX25hbWUsXG4gICAgICByZWdpb246IHRoaXMuX3JlZ2lvbixcbiAgICAgIHNlcnZpY2Vfcm9sZV9hcm46IHRoaXMuX3NlcnZpY2VSb2xlQXJuLFxuICAgICAgdGFnczogdGhpcy5fdGFncyxcbiAgICAgIHVzZV9jdXN0b21fY29va2Jvb2tzOiB0aGlzLl91c2VDdXN0b21Db29rYm9va3MsXG4gICAgICB1c2Vfb3Bzd29ya3Nfc2VjdXJpdHlfZ3JvdXBzOiB0aGlzLl91c2VPcHN3b3Jrc1NlY3VyaXR5R3JvdXBzLFxuICAgICAgdnBjX2lkOiB0aGlzLl92cGNJZCxcbiAgICAgIGN1c3RvbV9jb29rYm9va3Nfc291cmNlOiB0aGlzLl9jdXN0b21Db29rYm9va3NTb3VyY2UsXG4gICAgfTtcbiAgfVxufVxuIl19