import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface OrganizationsAccountConfig extends TerraformMetaArguments {
    readonly email: string;
    readonly iamUserAccessToBilling?: string;
    readonly name: string;
    readonly parentId?: string;
    readonly roleName?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class OrganizationsAccount extends TerraformResource {
    constructor(scope: Construct, id: string, config: OrganizationsAccountConfig);
    get arn(): string;
    private _email;
    get email(): string;
    set email(value: string);
    private _iamUserAccessToBilling?;
    get iamUserAccessToBilling(): string | undefined;
    set iamUserAccessToBilling(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get joinedMethod(): string;
    get joinedTimestamp(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _parentId?;
    get parentId(): string | undefined;
    set parentId(value: string | undefined);
    private _roleName?;
    get roleName(): string | undefined;
    set roleName(value: string | undefined);
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
