import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface OrganizationsOrganizationConfig extends TerraformMetaArguments {
    readonly awsServiceAccessPrincipals?: string[];
    readonly enabledPolicyTypes?: string[];
    readonly featureSet?: string;
}
export declare class OrganizationsOrganizationAccounts extends ComplexComputedList {
    get arn(): string;
    get email(): string;
    get id(): string;
    get name(): string;
    get status(): string;
}
export declare class OrganizationsOrganizationNonMasterAccounts extends ComplexComputedList {
    get arn(): string;
    get email(): string;
    get id(): string;
    get name(): string;
    get status(): string;
}
export declare class OrganizationsOrganizationRootsPolicyTypes extends ComplexComputedList {
    get status(): string;
    get type(): string;
}
export declare class OrganizationsOrganizationRoots extends ComplexComputedList {
    get arn(): string;
    get id(): string;
    get name(): string;
    get policyTypes(): any;
}
export declare class OrganizationsOrganization extends TerraformResource {
    constructor(scope: Construct, id: string, config?: OrganizationsOrganizationConfig);
    accounts(index: string): OrganizationsOrganizationAccounts;
    get arn(): string;
    private _awsServiceAccessPrincipals?;
    get awsServiceAccessPrincipals(): string[] | undefined;
    set awsServiceAccessPrincipals(value: string[] | undefined);
    private _enabledPolicyTypes?;
    get enabledPolicyTypes(): string[] | undefined;
    set enabledPolicyTypes(value: string[] | undefined);
    private _featureSet?;
    get featureSet(): string | undefined;
    set featureSet(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get masterAccountArn(): string;
    get masterAccountEmail(): string;
    get masterAccountId(): string;
    nonMasterAccounts(index: string): OrganizationsOrganizationNonMasterAccounts;
    roots(index: string): OrganizationsOrganizationRoots;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
