import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface PinpointAppConfig extends TerraformMetaArguments {
    readonly name?: string;
    readonly namePrefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** campaign_hook block */
    readonly campaignHook?: PinpointAppCampaignHook[];
    /** limits block */
    readonly limits?: PinpointAppLimits[];
    /** quiet_time block */
    readonly quietTime?: PinpointAppQuietTime[];
}
export interface PinpointAppCampaignHook {
    readonly lambdaFunctionName?: string;
    readonly mode?: string;
    readonly webUrl?: string;
}
export interface PinpointAppLimits {
    readonly daily?: number;
    readonly maximumDuration?: number;
    readonly messagesPerSecond?: number;
    readonly total?: number;
}
export interface PinpointAppQuietTime {
    readonly end?: string;
    readonly start?: string;
}
export declare class PinpointApp extends TerraformResource {
    constructor(scope: Construct, id: string, config?: PinpointAppConfig);
    get applicationId(): string;
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _campaignHook?;
    get campaignHook(): PinpointAppCampaignHook[] | undefined;
    set campaignHook(value: PinpointAppCampaignHook[] | undefined);
    private _limits?;
    get limits(): PinpointAppLimits[] | undefined;
    set limits(value: PinpointAppLimits[] | undefined);
    private _quietTime?;
    get quietTime(): PinpointAppQuietTime[] | undefined;
    set quietTime(value: PinpointAppQuietTime[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
