import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface PlacementGroupConfig extends TerraformMetaArguments {
    readonly name: string;
    readonly strategy: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class PlacementGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: PlacementGroupConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    get placementGroupId(): string;
    private _strategy;
    get strategy(): string;
    set strategy(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
