import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface QuicksightUserConfig extends TerraformMetaArguments {
    readonly awsAccountId?: string;
    readonly email: string;
    readonly iamArn?: string;
    readonly identityType: string;
    readonly namespace?: string;
    readonly sessionName?: string;
    readonly userName?: string;
    readonly userRole: string;
}
export declare class QuicksightUser extends TerraformResource {
    constructor(scope: Construct, id: string, config: QuicksightUserConfig);
    get arn(): string;
    private _awsAccountId?;
    get awsAccountId(): string | undefined;
    set awsAccountId(value: string | undefined);
    private _email;
    get email(): string;
    set email(value: string);
    private _iamArn?;
    get iamArn(): string | undefined;
    set iamArn(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identityType;
    get identityType(): string;
    set identityType(value: string);
    private _namespace?;
    get namespace(): string | undefined;
    set namespace(value: string | undefined);
    private _sessionName?;
    get sessionName(): string | undefined;
    set sessionName(value: string | undefined);
    private _userName?;
    get userName(): string | undefined;
    set userName(value: string | undefined);
    private _userRole;
    get userRole(): string;
    set userRole(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
