import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RamResourceShareAccepterConfig extends TerraformMetaArguments {
    readonly shareArn: string;
    /** timeouts block */
    readonly timeouts?: RamResourceShareAccepterTimeouts;
}
export interface RamResourceShareAccepterTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class RamResourceShareAccepter extends TerraformResource {
    constructor(scope: Construct, id: string, config: RamResourceShareAccepterConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get invitationArn(): string;
    get receiverAccountId(): string;
    get resources(): string[];
    get senderAccountId(): string;
    private _shareArn;
    get shareArn(): string;
    set shareArn(value: string);
    get shareId(): string;
    get shareName(): string;
    get status(): string;
    private _timeouts?;
    get timeouts(): RamResourceShareAccepterTimeouts | undefined;
    set timeouts(value: RamResourceShareAccepterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
