import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RamResourceShareConfig extends TerraformMetaArguments {
    readonly allowExternalPrincipals?: boolean;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: RamResourceShareTimeouts;
}
export interface RamResourceShareTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class RamResourceShare extends TerraformResource {
    constructor(scope: Construct, id: string, config: RamResourceShareConfig);
    private _allowExternalPrincipals?;
    get allowExternalPrincipals(): boolean | undefined;
    set allowExternalPrincipals(value: boolean | undefined);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _timeouts?;
    get timeouts(): RamResourceShareTimeouts | undefined;
    set timeouts(value: RamResourceShareTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
