import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RdsClusterEndpointConfig extends TerraformMetaArguments {
    readonly clusterEndpointIdentifier: string;
    readonly clusterIdentifier: string;
    readonly customEndpointType: string;
    readonly excludedMembers?: string[];
    readonly staticMembers?: string[];
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class RdsClusterEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: RdsClusterEndpointConfig);
    get arn(): string;
    private _clusterEndpointIdentifier;
    get clusterEndpointIdentifier(): string;
    set clusterEndpointIdentifier(value: string);
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    private _customEndpointType;
    get customEndpointType(): string;
    set customEndpointType(value: string);
    get endpoint(): string;
    private _excludedMembers?;
    get excludedMembers(): string[] | undefined;
    set excludedMembers(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _staticMembers?;
    get staticMembers(): string[] | undefined;
    set staticMembers(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
