import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RdsClusterInstanceConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly autoMinorVersionUpgrade?: boolean;
    readonly availabilityZone?: string;
    readonly caCertIdentifier?: string;
    readonly clusterIdentifier: string;
    readonly copyTagsToSnapshot?: boolean;
    readonly dbParameterGroupName?: string;
    readonly dbSubnetGroupName?: string;
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly identifier?: string;
    readonly identifierPrefix?: string;
    readonly instanceClass: string;
    readonly monitoringInterval?: number;
    readonly monitoringRoleArn?: string;
    readonly performanceInsightsEnabled?: boolean;
    readonly performanceInsightsKmsKeyId?: string;
    readonly preferredBackupWindow?: string;
    readonly preferredMaintenanceWindow?: string;
    readonly promotionTier?: number;
    readonly publiclyAccessible?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    /** timeouts block */
    readonly timeouts?: RdsClusterInstanceTimeouts;
}
export interface RdsClusterInstanceTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class RdsClusterInstance extends TerraformResource {
    constructor(scope: Construct, id: string, config: RdsClusterInstanceConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _autoMinorVersionUpgrade?;
    get autoMinorVersionUpgrade(): boolean | undefined;
    set autoMinorVersionUpgrade(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _caCertIdentifier?;
    get caCertIdentifier(): string | undefined;
    set caCertIdentifier(value: string | undefined);
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    private _copyTagsToSnapshot?;
    get copyTagsToSnapshot(): boolean | undefined;
    set copyTagsToSnapshot(value: boolean | undefined);
    private _dbParameterGroupName?;
    get dbParameterGroupName(): string | undefined;
    set dbParameterGroupName(value: string | undefined);
    private _dbSubnetGroupName?;
    get dbSubnetGroupName(): string | undefined;
    set dbSubnetGroupName(value: string | undefined);
    get dbiResourceId(): string;
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identifier?;
    get identifier(): string | undefined;
    set identifier(value: string | undefined);
    private _identifierPrefix?;
    get identifierPrefix(): string | undefined;
    set identifierPrefix(value: string | undefined);
    private _instanceClass;
    get instanceClass(): string;
    set instanceClass(value: string);
    get kmsKeyId(): string;
    private _monitoringInterval?;
    get monitoringInterval(): number | undefined;
    set monitoringInterval(value: number | undefined);
    private _monitoringRoleArn?;
    get monitoringRoleArn(): string | undefined;
    set monitoringRoleArn(value: string | undefined);
    private _performanceInsightsEnabled?;
    get performanceInsightsEnabled(): boolean | undefined;
    set performanceInsightsEnabled(value: boolean | undefined);
    private _performanceInsightsKmsKeyId?;
    get performanceInsightsKmsKeyId(): string | undefined;
    set performanceInsightsKmsKeyId(value: string | undefined);
    get port(): number;
    private _preferredBackupWindow?;
    get preferredBackupWindow(): string | undefined;
    set preferredBackupWindow(value: string | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    private _promotionTier?;
    get promotionTier(): number | undefined;
    set promotionTier(value: number | undefined);
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    get storageEncrypted(): boolean;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get writer(): boolean;
    private _timeouts?;
    get timeouts(): RdsClusterInstanceTimeouts | undefined;
    set timeouts(value: RdsClusterInstanceTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
