import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RdsClusterConfig extends TerraformMetaArguments {
    readonly applyImmediately?: boolean;
    readonly availabilityZones?: string[];
    readonly backtrackWindow?: number;
    readonly backupRetentionPeriod?: number;
    readonly clusterIdentifier?: string;
    readonly clusterIdentifierPrefix?: string;
    readonly clusterMembers?: string[];
    readonly copyTagsToSnapshot?: boolean;
    readonly databaseName?: string;
    readonly dbClusterParameterGroupName?: string;
    readonly dbSubnetGroupName?: string;
    readonly deletionProtection?: boolean;
    readonly enableHttpEndpoint?: boolean;
    readonly enabledCloudwatchLogsExports?: string[];
    readonly engine?: string;
    readonly engineMode?: string;
    readonly engineVersion?: string;
    readonly finalSnapshotIdentifier?: string;
    readonly globalClusterIdentifier?: string;
    readonly iamDatabaseAuthenticationEnabled?: boolean;
    readonly iamRoles?: string[];
    readonly kmsKeyId?: string;
    readonly masterPassword?: string;
    readonly masterUsername?: string;
    readonly port?: number;
    readonly preferredBackupWindow?: string;
    readonly preferredMaintenanceWindow?: string;
    readonly replicationSourceIdentifier?: string;
    readonly skipFinalSnapshot?: boolean;
    readonly snapshotIdentifier?: string;
    readonly sourceRegion?: string;
    readonly storageEncrypted?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** s3_import block */
    readonly s3Import?: RdsClusterS3Import[];
    /** scaling_configuration block */
    readonly scalingConfiguration?: RdsClusterScalingConfiguration[];
    /** timeouts block */
    readonly timeouts?: RdsClusterTimeouts;
}
export interface RdsClusterS3Import {
    readonly bucketName: string;
    readonly bucketPrefix?: string;
    readonly ingestionRole: string;
    readonly sourceEngine: string;
    readonly sourceEngineVersion: string;
}
export interface RdsClusterScalingConfiguration {
    readonly autoPause?: boolean;
    readonly maxCapacity?: number;
    readonly minCapacity?: number;
    readonly secondsUntilAutoPause?: number;
    readonly timeoutAction?: string;
}
export interface RdsClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class RdsCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config?: RdsClusterConfig);
    private _applyImmediately?;
    get applyImmediately(): boolean | undefined;
    set applyImmediately(value: boolean | undefined);
    get arn(): string;
    private _availabilityZones?;
    get availabilityZones(): string[] | undefined;
    set availabilityZones(value: string[] | undefined);
    private _backtrackWindow?;
    get backtrackWindow(): number | undefined;
    set backtrackWindow(value: number | undefined);
    private _backupRetentionPeriod?;
    get backupRetentionPeriod(): number | undefined;
    set backupRetentionPeriod(value: number | undefined);
    private _clusterIdentifier?;
    get clusterIdentifier(): string | undefined;
    set clusterIdentifier(value: string | undefined);
    private _clusterIdentifierPrefix?;
    get clusterIdentifierPrefix(): string | undefined;
    set clusterIdentifierPrefix(value: string | undefined);
    private _clusterMembers?;
    get clusterMembers(): string[] | undefined;
    set clusterMembers(value: string[] | undefined);
    get clusterResourceId(): string;
    private _copyTagsToSnapshot?;
    get copyTagsToSnapshot(): boolean | undefined;
    set copyTagsToSnapshot(value: boolean | undefined);
    private _databaseName?;
    get databaseName(): string | undefined;
    set databaseName(value: string | undefined);
    private _dbClusterParameterGroupName?;
    get dbClusterParameterGroupName(): string | undefined;
    set dbClusterParameterGroupName(value: string | undefined);
    private _dbSubnetGroupName?;
    get dbSubnetGroupName(): string | undefined;
    set dbSubnetGroupName(value: string | undefined);
    private _deletionProtection?;
    get deletionProtection(): boolean | undefined;
    set deletionProtection(value: boolean | undefined);
    private _enableHttpEndpoint?;
    get enableHttpEndpoint(): boolean | undefined;
    set enableHttpEndpoint(value: boolean | undefined);
    private _enabledCloudwatchLogsExports?;
    get enabledCloudwatchLogsExports(): string[] | undefined;
    set enabledCloudwatchLogsExports(value: string[] | undefined);
    get endpoint(): string;
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineMode?;
    get engineMode(): string | undefined;
    set engineMode(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _finalSnapshotIdentifier?;
    get finalSnapshotIdentifier(): string | undefined;
    set finalSnapshotIdentifier(value: string | undefined);
    private _globalClusterIdentifier?;
    get globalClusterIdentifier(): string | undefined;
    set globalClusterIdentifier(value: string | undefined);
    get hostedZoneId(): string;
    private _iamDatabaseAuthenticationEnabled?;
    get iamDatabaseAuthenticationEnabled(): boolean | undefined;
    set iamDatabaseAuthenticationEnabled(value: boolean | undefined);
    private _iamRoles?;
    get iamRoles(): string[] | undefined;
    set iamRoles(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _masterPassword?;
    get masterPassword(): string | undefined;
    set masterPassword(value: string | undefined);
    private _masterUsername?;
    get masterUsername(): string | undefined;
    set masterUsername(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredBackupWindow?;
    get preferredBackupWindow(): string | undefined;
    set preferredBackupWindow(value: string | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    get readerEndpoint(): string;
    private _replicationSourceIdentifier?;
    get replicationSourceIdentifier(): string | undefined;
    set replicationSourceIdentifier(value: string | undefined);
    private _skipFinalSnapshot?;
    get skipFinalSnapshot(): boolean | undefined;
    set skipFinalSnapshot(value: boolean | undefined);
    private _snapshotIdentifier?;
    get snapshotIdentifier(): string | undefined;
    set snapshotIdentifier(value: string | undefined);
    private _sourceRegion?;
    get sourceRegion(): string | undefined;
    set sourceRegion(value: string | undefined);
    private _storageEncrypted?;
    get storageEncrypted(): boolean | undefined;
    set storageEncrypted(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _s3Import?;
    get s3Import(): RdsClusterS3Import[] | undefined;
    set s3Import(value: RdsClusterS3Import[] | undefined);
    private _scalingConfiguration?;
    get scalingConfiguration(): RdsClusterScalingConfiguration[] | undefined;
    set scalingConfiguration(value: RdsClusterScalingConfiguration[] | undefined);
    private _timeouts?;
    get timeouts(): RdsClusterTimeouts | undefined;
    set timeouts(value: RdsClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
