import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RdsGlobalClusterConfig extends TerraformMetaArguments {
    readonly databaseName?: string;
    readonly deletionProtection?: boolean;
    readonly engine?: string;
    readonly engineVersion?: string;
    readonly globalClusterIdentifier: string;
    readonly storageEncrypted?: boolean;
}
export declare class RdsGlobalCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: RdsGlobalClusterConfig);
    get arn(): string;
    private _databaseName?;
    get databaseName(): string | undefined;
    set databaseName(value: string | undefined);
    private _deletionProtection?;
    get deletionProtection(): boolean | undefined;
    set deletionProtection(value: boolean | undefined);
    private _engine?;
    get engine(): string | undefined;
    set engine(value: string | undefined);
    private _engineVersion?;
    get engineVersion(): string | undefined;
    set engineVersion(value: string | undefined);
    private _globalClusterIdentifier;
    get globalClusterIdentifier(): string;
    set globalClusterIdentifier(value: string);
    get globalClusterResourceId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _storageEncrypted?;
    get storageEncrypted(): boolean | undefined;
    set storageEncrypted(value: boolean | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
