import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RedshiftClusterConfig extends TerraformMetaArguments {
    readonly allowVersionUpgrade?: boolean;
    readonly automatedSnapshotRetentionPeriod?: number;
    readonly availabilityZone?: string;
    readonly bucketName?: string;
    readonly clusterIdentifier: string;
    readonly clusterParameterGroupName?: string;
    readonly clusterPublicKey?: string;
    readonly clusterRevisionNumber?: string;
    readonly clusterSecurityGroups?: string[];
    readonly clusterSubnetGroupName?: string;
    readonly clusterType?: string;
    readonly clusterVersion?: string;
    readonly databaseName?: string;
    readonly elasticIp?: string;
    readonly enableLogging?: boolean;
    readonly encrypted?: boolean;
    readonly endpoint?: string;
    readonly enhancedVpcRouting?: boolean;
    readonly finalSnapshotIdentifier?: string;
    readonly iamRoles?: string[];
    readonly kmsKeyId?: string;
    readonly masterPassword?: string;
    readonly masterUsername?: string;
    readonly nodeType: string;
    readonly numberOfNodes?: number;
    readonly ownerAccount?: string;
    readonly port?: number;
    readonly preferredMaintenanceWindow?: string;
    readonly publiclyAccessible?: boolean;
    readonly s3KeyPrefix?: string;
    readonly skipFinalSnapshot?: boolean;
    readonly snapshotClusterIdentifier?: string;
    readonly snapshotIdentifier?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcSecurityGroupIds?: string[];
    /** logging block */
    readonly logging?: RedshiftClusterLogging[];
    /** snapshot_copy block */
    readonly snapshotCopy?: RedshiftClusterSnapshotCopy[];
    /** timeouts block */
    readonly timeouts?: RedshiftClusterTimeouts;
}
export interface RedshiftClusterLogging {
    readonly bucketName?: string;
    readonly enable: boolean;
    readonly s3KeyPrefix?: string;
}
export interface RedshiftClusterSnapshotCopy {
    readonly destinationRegion: string;
    readonly grantName?: string;
    readonly retentionPeriod?: number;
}
export interface RedshiftClusterTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class RedshiftCluster extends TerraformResource {
    constructor(scope: Construct, id: string, config: RedshiftClusterConfig);
    private _allowVersionUpgrade?;
    get allowVersionUpgrade(): boolean | undefined;
    set allowVersionUpgrade(value: boolean | undefined);
    get arn(): string;
    private _automatedSnapshotRetentionPeriod?;
    get automatedSnapshotRetentionPeriod(): number | undefined;
    set automatedSnapshotRetentionPeriod(value: number | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _bucketName?;
    get bucketName(): string | undefined;
    set bucketName(value: string | undefined);
    private _clusterIdentifier;
    get clusterIdentifier(): string;
    set clusterIdentifier(value: string);
    private _clusterParameterGroupName?;
    get clusterParameterGroupName(): string | undefined;
    set clusterParameterGroupName(value: string | undefined);
    private _clusterPublicKey?;
    get clusterPublicKey(): string | undefined;
    set clusterPublicKey(value: string | undefined);
    private _clusterRevisionNumber?;
    get clusterRevisionNumber(): string | undefined;
    set clusterRevisionNumber(value: string | undefined);
    private _clusterSecurityGroups?;
    get clusterSecurityGroups(): string[] | undefined;
    set clusterSecurityGroups(value: string[] | undefined);
    private _clusterSubnetGroupName?;
    get clusterSubnetGroupName(): string | undefined;
    set clusterSubnetGroupName(value: string | undefined);
    private _clusterType?;
    get clusterType(): string | undefined;
    set clusterType(value: string | undefined);
    private _clusterVersion?;
    get clusterVersion(): string | undefined;
    set clusterVersion(value: string | undefined);
    private _databaseName?;
    get databaseName(): string | undefined;
    set databaseName(value: string | undefined);
    get dnsName(): string;
    private _elasticIp?;
    get elasticIp(): string | undefined;
    set elasticIp(value: string | undefined);
    private _enableLogging?;
    get enableLogging(): boolean | undefined;
    set enableLogging(value: boolean | undefined);
    private _encrypted?;
    get encrypted(): boolean | undefined;
    set encrypted(value: boolean | undefined);
    private _endpoint?;
    get endpoint(): string | undefined;
    set endpoint(value: string | undefined);
    private _enhancedVpcRouting?;
    get enhancedVpcRouting(): boolean | undefined;
    set enhancedVpcRouting(value: boolean | undefined);
    private _finalSnapshotIdentifier?;
    get finalSnapshotIdentifier(): string | undefined;
    set finalSnapshotIdentifier(value: string | undefined);
    private _iamRoles?;
    get iamRoles(): string[] | undefined;
    set iamRoles(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsKeyId?;
    get kmsKeyId(): string | undefined;
    set kmsKeyId(value: string | undefined);
    private _masterPassword?;
    get masterPassword(): string | undefined;
    set masterPassword(value: string | undefined);
    private _masterUsername?;
    get masterUsername(): string | undefined;
    set masterUsername(value: string | undefined);
    private _nodeType;
    get nodeType(): string;
    set nodeType(value: string);
    private _numberOfNodes?;
    get numberOfNodes(): number | undefined;
    set numberOfNodes(value: number | undefined);
    private _ownerAccount?;
    get ownerAccount(): string | undefined;
    set ownerAccount(value: string | undefined);
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    private _preferredMaintenanceWindow?;
    get preferredMaintenanceWindow(): string | undefined;
    set preferredMaintenanceWindow(value: string | undefined);
    private _publiclyAccessible?;
    get publiclyAccessible(): boolean | undefined;
    set publiclyAccessible(value: boolean | undefined);
    private _s3KeyPrefix?;
    get s3KeyPrefix(): string | undefined;
    set s3KeyPrefix(value: string | undefined);
    private _skipFinalSnapshot?;
    get skipFinalSnapshot(): boolean | undefined;
    set skipFinalSnapshot(value: boolean | undefined);
    private _snapshotClusterIdentifier?;
    get snapshotClusterIdentifier(): string | undefined;
    set snapshotClusterIdentifier(value: string | undefined);
    private _snapshotIdentifier?;
    get snapshotIdentifier(): string | undefined;
    set snapshotIdentifier(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcSecurityGroupIds?;
    get vpcSecurityGroupIds(): string[] | undefined;
    set vpcSecurityGroupIds(value: string[] | undefined);
    private _logging?;
    get logging(): RedshiftClusterLogging[] | undefined;
    set logging(value: RedshiftClusterLogging[] | undefined);
    private _snapshotCopy?;
    get snapshotCopy(): RedshiftClusterSnapshotCopy[] | undefined;
    set snapshotCopy(value: RedshiftClusterSnapshotCopy[] | undefined);
    private _timeouts?;
    get timeouts(): RedshiftClusterTimeouts | undefined;
    set timeouts(value: RedshiftClusterTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
