import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface RedshiftParameterGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly family: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** parameter block */
    readonly parameter?: RedshiftParameterGroupParameter[];
}
export interface RedshiftParameterGroupParameter {
    readonly name: string;
    readonly value: string;
}
export declare class RedshiftParameterGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: RedshiftParameterGroupConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _family;
    get family(): string;
    set family(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _parameter?;
    get parameter(): RedshiftParameterGroupParameter[] | undefined;
    set parameter(value: RedshiftParameterGroupParameter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
